% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bizicount-methods.R
\docType{class}
\name{bizicount-class}
\alias{bizicount-class}
\title{The bizicount S4 Class}
\description{
Note that \code{bizicount} objects are generally S3, and should use
S3 syntax. This S4 class is defined only for compatability with
\code{\link[texreg]{texreg}}. However, the contents of \code{bizicount} objects
is the same in both S3 and S4, so the descriptions below apply in both cases.
}
\section{Slots}{

\describe{
\item{\code{coef}}{Coefficients of the model}

\item{\code{coef.nid}}{Coefficients without margin IDs}

\item{\code{coef.orig}}{Coefficients prior to transformations, for Gaussian
dependence and negative binomial dispersion.}

\item{\code{coef.orig.nid}}{Coefficients prior to transforms, no margin IDs.}

\item{\code{se}}{Asymptotic standard errors based on observed Fisher Information}

\item{\code{se.nid}}{Standard errors without margin IDs}

\item{\code{z}}{z-scores for parameter estimates}

\item{\code{z.nid}}{z-scores without margin IDs}

\item{\code{p}}{p-values for parameter estimates}

\item{\code{p.nid}}{p-values without margin IDs}

\item{\code{coefmats}}{A list containing coefficient matrices for each margin}

\item{\code{loglik}}{Scalar log-likelihood at convergence}

\item{\code{grad}}{Gradient vector at convergence}

\item{\code{n.iter}}{Number of quasi-newton fitting iterations.}

\item{\code{covmat}}{Covariance matrix of parameter estimates based on observed Fisher Information}

\item{\code{aic}}{Model's Akaike information}

\item{\code{bic}}{Model's Bayesian information criterion}

\item{\code{nobs}}{Number of observations}

\item{\code{margins}}{Marginal distributions used in fitting}

\item{\code{link.zi,link.ct}}{Names of link functions used in fitting}

\item{\code{invlink.ct,invlink.zi}}{Inverse link functions used in fitting (the
actual function, not their names)}

\item{\code{outcomes}}{Name of the response vector}

\item{\code{conv}}{Integer telling convergence status.}

\item{\code{cop}}{The copula used in fitting}

\item{\code{starts}}{list of starting values used}

\item{\code{call}}{The model's call}

\item{\code{model}}{List containing model matrices, or \code{NULL} if \code{keep = F}.}
}}

