% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reclassToBats.R
\name{reclassToBats}
\alias{reclassToBats}
\title{integrate bat classification}
\usage{
reclassToBats(
  echoData = NULL,
  batClassProbabilitiesAndMtrFactors = NULL,
  reclassToBatCutoff = -1
)
}
\arguments{
\item{echoData}{echodata dataframe, output from extractDbData}

\item{batClassProbabilitiesAndMtrFactors}{probabilities of bat classification,
output from extractDbData'}

\item{reclassToBatCutoff}{Threshold (0..1), classification of echoes with
bat probability higher than reclassToBatCutoff will be set to 'bat'}
}
\value{
echoData dataframe
}
\description{
reclassifies echoes based on bat classification
}
\examples{
\dontrun{
# Set server, database, and other input settings
# ===========================================================================
  dbServer       = "MACHINE\\\\SERVERNAME"     # Set the name of your SQL server
  dbName         = "db_Name"                   # Set the name of your database
  dbDriverChar   = "SQL Server"                # Set either "SQL Server" or "PostgreSQL"
  mainOutputDir  = file.path(".", "results")
  radarTimeZone  = "Etc/GMT0"
  targetTimeZone = "Etc/GMT0"
  listOfRfFeaturesToExtract = c(167, 168)
  siteLocation   = c(47.494427, 8.716432)
  sunOrCivil   = "civil"
 
# Get data
# ===========================================================================
  dbData = extractDbData(dbDriverChar                   = dbDriverChar,
                         dbServer                       = dbServer, 
                         dbName                         = dbName, 
                         saveDbToFile                   = TRUE,
                         dbDataDir                      = mainOutputDir,
                         radarTimeZone                  = radarTimeZone,
                         targetTimeZone                 = targetTimeZone,
                         listOfRfFeaturesToExtract      = listOfRfFeaturesToExtract,
                         siteLocation                   = siteLocation, 
                         sunOrCivil                   = sunOrCivil,
                         crepuscule                     = "nauticalSolar")
#' 
# Reclass To Bats
# ===========================================================================
  dbData$echoData = reclassToBats(echoData = dbData$echoData,
                                  batClassProbabilitiesAndMtrFactors = 
                                      dbData$batClassProbabilitiesAndMtrFactors,
                                  reclassToBatCutoff = 0.5)
}
}
\author{
Fabian Hertner, \email{fabian.hertner@swiss-birdradar.com}
}
