% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractDbData.R
\name{extractDbData}
\alias{extractDbData}
\title{Extract DB Data}
\usage{
extractDbData(
  dbDriverChar = "SQL Server",
  dbServer = NULL,
  dbName = NULL,
  dbUser = NULL,
  dbPwd = NULL,
  saveDbToFile = FALSE,
  dbDataDir = NULL,
  radarTimeZone = NULL,
  targetTimeZone = "Etc/GMT0",
  listOfRfFeaturesToExtract = NULL,
  siteLocation = NULL,
  sunOrCivil = "civil",
  crepuscule = "nauticalSolar"
)
}
\arguments{
\item{dbDriverChar}{'SQL Server' The name of the driver. Should be either
'SQL Server' or 'PostgreSQL'. If 'PostgreSQL', it connects to
cloud.birdradar.com}

\item{dbServer}{NULL The name of the Server}

\item{dbName}{NULL The name of the Database}

\item{dbUser}{NULL The USER name of the Server}

\item{dbPwd}{NULL The password for the user name}

\item{saveDbToFile}{FALSE Set to TRUE if you want to save the extracted
database data to an rds file. The output filename is automatically set to
dbName_DataExtract.rds}

\item{dbDataDir}{NULL The path to the output directory where to store the
extracted dataset. If the directory does not exist, it will be created.}

\item{radarTimeZone}{NULL String specifying the radar time zone. Default is
NULL: extract the time zone from the site table of the 'SQL' database.}

\item{targetTimeZone}{"Etc/GMT0" String specifying the target time zone.
Default is "Etc/GMT0".}

\item{listOfRfFeaturesToExtract}{NULL or a list of feature to extract}

\item{siteLocation}{Geographic location of the radar measurements in decimal
format: c(Latitude, Longitude)}

\item{sunOrCivil}{optional character variable, Set to “sun” to use
sunrise/sunset times or to “civil” to use civil twilight times to group echoes
into day/night. Default is "civil".}

\item{crepuscule}{optional character variable, Set to “nauticalSolar” to use
the time between nautical dusk/dawn and sunrise/sunset times to define the
crepuscular period, or to "nauticalCivil" to use the time between nautical
and civil dusk/dawn to define the crepuscular period, or to "civilSolar" to use
the time between civil dusk/dawn and sunrise/sunset times to define the
crepuscular period. Default is "nauticalSolar".}
}
\value{
a list of R objects with data extracted from the Database: 'echoData',
'protocolData', 'siteData', 'visibilityData', 'timeBinData', 'rfFeatures',
'availableClasses', 'availableBatClasses', 'classProbabilitiesAndMtrFactors',
'batProbabilitiesAndMtrFactors'
}
\description{
Load the data from the database or file and save it to file
}
\examples{
\dontrun{
# Set server, database, and other input settings
# ===========================================================================
  dbServer       = "MACHINE\\\\SERVERNAME"     # Set the name of your SQL server
  dbName         = "db_Name"                   # Set the name of your database
  dbDriverChar   = "SQL Server"                # Set either "SQL Server" or "PostgreSQL"
  mainOutputDir  = file.path(".", "results")
  radarTimeZone  = "Etc/GMT0"
  targetTimeZone = "Etc/GMT0"
  listOfRfFeaturesToExtract = c(167, 168)
  siteLocation   = c(47.494427, 8.716432)
  sunOrCivil   = "civil"
 
# Get data
# ===========================================================================
  dbData = extractDbData(dbDriverChar                   = dbDriverChar,
                         dbServer                       = dbServer, 
                         dbName                         = dbName, 
                         saveDbToFile                   = TRUE,
                         dbDataDir                      = mainOutputDir,
                         radarTimeZone                  = radarTimeZone,
                         targetTimeZone                 = targetTimeZone,
                         listOfRfFeaturesToExtract      = listOfRfFeaturesToExtract,
                         siteLocation                   = siteLocation, 
                         sunOrCivil                   = sunOrCivil,
                         crepuscule                     = "nauticalSolar")
}

}
\author{
Fabian Hertner, \email{fabian.hertner@swiss-birdradar.com};
Birgen Haest, \email{birgen.haest@vogelwarte.ch}
}
