% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MDS.R
\name{regress}
\alias{regress}
\title{Regression biplot method}
\usage{
regress(bp, Z, group.aes=NULL, show.group.means = TRUE, 
               axes = c("regression", "splines"))
}
\arguments{
\item{bp}{an object of class \code{biplot} obtained from preceding function \code{biplot()}.}

\item{Z}{the matrix of coordinates of the samples}

\item{group.aes}{vector of the same length as the number of rows in the data matrix
for differentiated aesthetics for samples.}

\item{show.group.means}{logical, indicating whether group means should be plotted in the biplot.}

\item{axes}{the type of axes to be fitted to the biplot. Options are 'regression' for linear
regression axes (default) and 'splines' for B-spline axes.}
}
\value{
Object of class biplot
}
\description{
Regression biplot method
}
\examples{
biplot(iris[,1:4]) |> regress(Z=cmdscale(dist(iris[,1:4]))) |> plot()
}
