% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CVA.R
\name{AoD.biplot}
\alias{AoD.biplot}
\title{Calculate elements for the Analysis of Distance (AoD) biplot}
\usage{
\method{AoD}{biplot}(
  bp,
  classes = bp$classes,
  dist.func = NULL,
  dist.func.cat = NULL,
  dim.biplot = c(2, 1, 3),
  e.vects = 1:ncol(bp$X),
  weighted = c("unweighted", "weighted"),
  show.class.means = TRUE,
  axes = c("regression", "splines"),
  ...
)
}
\arguments{
\item{bp}{an object of class \code{biplot} obtained from preceding function \code{biplot()}.}

\item{classes}{a vector of the same length as the number of rows in the data matrix with the class indicator for the samples.}

\item{dist.func}{a character string indicating which distance function is used to compute the Euclidean embeddable distances between samples. One of \code{NULL} (default) which computes the Euclidean distance or other functions that can be used for the \code{dist()} function.}

\item{dist.func.cat}{a character string indicating which distance function is used to compute the Euclidean embeddable distances between samples. One of \code{NULL} (default) which computes the extended matching coefficient or other functions.}

\item{dim.biplot}{the dimension of the biplot. Only values \code{1}, \code{2} and \code{3} are accepted, with default \code{2}.}

\item{e.vects}{the vector indicating which eigenvectors (canonical variates) should be plotted in the biplot, with default \code{1:dim.biplot}.}

\item{weighted}{a character string indicating the weighting of the classes. One of "\code{unweighted}" for each class to receive equal weighting or "\code{weighted}" for each class to receive their class sizes as weights.}

\item{show.class.means}{a logical value indicating whether to plot the class means on the biplot.}

\item{axes}{a character string indicating the type of biplot axes to be used in the biplot. One of \code{"regression"} or \code{"splines"}.}

\item{...}{more arguments to \code{dist.func}.}
}
\value{
an object of class \code{biplot}.
}
\description{
This function is used to construct the AoD biplot
}
\examples{
biplot(iris) |> AoD(classes = iris[,5]) |> plot()

}
