% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing_values.R, R/outliers.R
\name{missing_values}
\alias{missing_values}
\alias{print.missing_values}
\alias{print.outliers}
\title{Descriptive and Visual Missing Value Assessment}
\usage{
missing_values(data, color = "#79E1BE", all = FALSE)

\method{print}{missing_values}(x, ...)

\method{print}{outliers}(x, ...)
}
\arguments{
\item{data}{Dataframe containing the variables to be analyzed.}

\item{color}{Character string indicating the color for missing values. Default: "#79E1BE"}

\item{all}{Logical parameter that shows all variables including those without missing values. Default: FALSE.}

\item{x}{An object of class "outliers".}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
An object of class "missing_values" containing descriptive statistics and ggplot objects.
}
\description{
Provides descriptive statistics and visualizations of missing values in a dataframe.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(missing_values)}: Print method for objects of class "missing_values".

}}
\section{Functions}{
\itemize{
\item \code{print(outliers)}: Print method for objects of class "outliers".

}}
\examples{
# Clinical dataset with missing values
clinical_df <- clinical_data(dropout = 0.1, missing = 0.05)

# Missing value analysis of only variables with missing values
missing_values(clinical_df)

# Show all variables including those without missing values
missing_values(clinical_df, all = TRUE)

}
