% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predl_templates.R
\name{predl_google_storage}
\alias{predl_google_storage}
\title{Pre-Download Google Storage}
\usage{
predl_google_storage(
  url,
  platform,
  history,
  appname,
  fileregex = "\\\\.zip$",
  platformregex = platform,
  versionregex = c(paste0("(.*)/.*", fileregex), "\\\\1")
)
}
\arguments{
\item{url}{A url giving the JSON bucket listings for a project. For
example: http://chromedriver.storage.googleapis.com/index.html
lists the chromedriver files but
https://www.googleapis.com/storage/v1/b/chromedriver/o/ is the
JSON listings for the project.}

\item{platform}{A character vector of platform names}

\item{history}{The maximum number of files to get for a platform}

\item{appname}{Name of the app}

\item{fileregex}{A filter for files}

\item{platformregex}{A filter for platforms. Defaults to the platform
names.}

\item{versionregex}{A regex for retrieving the version.}
}
\value{
A named list of data.frames. The name indicates the
    platform. The data.frame should contain the version, url and file
    to be processed. Used as input for \code{\link{download_files}} or
    an equivalent.
}
\description{
Pre-Download Google Storage template function
}
\examples{
\dontrun{
gsdata <- system.file("testdata", "test_googstor.json",
  package = "binman"
)
platform <- c("linux64", "win32", "mac64")
gsdllist <- predl_google_storage(
  url = gsdata, platform, history = 5L,
  appname = "binman_chromedriver"
)
}

}
