% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfa_boot_ci.R
\name{bfa_boot_ci}
\alias{bfa_boot_ci}
\title{Standard Normal Bootstrap Confidence Interval Function}
\usage{
bfa_boot_ci(a1_ls, a1_ls_star, conf_level = 0.95)
}
\arguments{
\item{a1_ls}{A numeric value of the least squares estimator of bifurcating autoregressive model}

\item{a1_ls_star}{A numeric vector representing B replicates of the least squares estimator}

\item{conf_level}{A numeric value representing the confidence level. Defaults to 0.95.}
}
\value{
A numeric vector representing the lower and upper limits of the confidence interval
}
\description{
This function calculates the standard normal bootstrap CI for the least squares estimator of the
bifurcating autoregressive model.
}
\examples{
a1_ls <- 0.7
a1_ls_star <- c(rnorm(100,0.7,0.05))
bfa_boot_ci(a1_ls, a1_ls_star, conf_level= 0.95)
}
