% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-brsmm.R
\name{plot.brsmm}
\alias{plot.brsmm}
\title{Diagnostic plots for mixed beta interval regression}
\usage{
\method{plot}{brsmm}(
  x,
  which = 1:4,
  type = c("response", "pearson"),
  nsim = 100L,
  level = 0.9,
  caption = c("Residuals vs indices", "Cook's distance", "Residuals vs linear predictor",
    "Residuals vs fitted values", "Half-normal plot", "Predicted vs observed"),
  sub.caption = NULL,
  ask = prod(par("mfcol")) < length(which) && dev.interactive(),
  gg = FALSE,
  title = NULL,
  theme = NULL,
  ...
)
}
\arguments{
\item{x}{A fitted \code{"brsmm"} object.}

\item{which}{Integer vector selecting which panels to draw
(default \code{1:4}).}

\item{type}{Residual type passed to \code{\link{residuals.brsmm}}
(\code{"response"} or \code{"pearson"}).}

\item{nsim}{Number of simulations for half-normal envelope.}

\item{level}{Confidence level for the half-normal envelope.}

\item{caption}{Character vector of plot captions.}

\item{sub.caption}{Optional subtitle; defaults to model call.}

\item{ask}{Logical: prompt before each new page?}

\item{gg}{Logical: use ggplot2 backend?}

\item{title}{Optional global title for ggplot output. If \code{NULL},
panel captions are used.}

\item{theme}{Optional ggplot2 theme object (e.g., \code{ggplot2::theme_bw()}).
If \code{NULL}, a minimal theme is used.}

\item{...}{Further arguments passed to base \code{plot()}.}
}
\value{
Invisibly returns \code{x}.
}
\description{
Produces diagnostic plots for fitted \code{"brsmm"} models:
residuals vs indices, Cook's distance, residuals vs linear predictor,
residuals vs fitted values, half-normal envelope, and predicted vs observed.
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10),
  id = factor(rep(1:4, each = 5))
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brsmm(y ~ x1, random = ~ 1 | id, data = prep)
plot(fit, which = 1:4)
}

}
\seealso{
\code{\link{brsmm}}, \code{\link{residuals.brsmm}},
  \code{\link{autoplot.brsmm}}
}
