% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{coef.brs}
\alias{coef.brs}
\title{Extract model coefficients}
\usage{
\method{coef}{brs}(object, model = c("full", "mean", "precision"), ...)
}
\arguments{
\item{object}{A fitted \code{"betaregscale"} object.}

\item{model}{Character: which component to return.
\code{"full"} (default) returns all parameters,
\code{"mean"} returns only the mean-model coefficients,
\code{"precision"} returns only the precision coefficients.}

\item{...}{Ignored.}
}
\value{
Named numeric vector of estimated parameters.
}
\description{
Extract model coefficients
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10)
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brs(y ~ x1, data = prep)
coef(fit)
coef(fit, model = "mean")
coef(fit, model = "precision")
}

}
\seealso{
\code{\link{brs}}, \code{\link{brs_est}}, \code{\link{vcov.brs}}
}
