% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.R
\name{brs_table}
\alias{brs_table}
\title{Compare fitted brs models in a single table}
\usage{
brs_table(
  ...,
  models = NULL,
  include_censoring = TRUE,
  sort_by = c("none", "AIC", "BIC", "logLik"),
  decreasing = FALSE,
  digits = 4L
)
}
\arguments{
\item{...}{Fitted \code{"brs"} objects passed individually.}

\item{models}{Optional list of fitted \code{"brs"} objects.
Use either \code{...} or \code{models}, not both.}

\item{include_censoring}{Logical; include censoring counts/proportions.
Default is \code{TRUE}.}

\item{sort_by}{Character; optional sort criterion:
\code{"none"} (default), \code{"AIC"}, \code{"BIC"}, or \code{"logLik"}.}

\item{decreasing}{Logical; sort direction when \code{sort_by != "none"}.}

\item{digits}{Integer number of digits used for numeric rounding.}
}
\value{
A data frame with one row per model.
}
\description{
Builds a comparison table for one or more fitted \code{"brs"} objects,
summarizing fit statistics and (optionally) censoring composition.
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10),
  x2 = rep(c(0, 0, 1, 1), 5)
)
prep <- brs_prep(dat, ncuts = 100)
m1 <- brs(y ~ 1, data = prep)
m2 <- brs(y ~ x1, data = prep)
brs_table(null = m1, x1 = m2, sort_by = "AIC")
}

}
\references{
Lopes, J. E. (2023). \emph{Modelos de regressao beta para dados de escala}.
Master's dissertation, Universidade Federal do Parana, Curitiba.
URI: \url{https://hdl.handle.net/1884/86624}.

Hawker, G. A., Mian, S., Kendzerska, T., and French, M. (2011).
Measures of adult pain: Visual Analog Scale for Pain (VAS Pain),
Numeric Rating Scale for Pain (NRS Pain), McGill Pain Questionnaire (MPQ),
Short-Form McGill Pain Questionnaire (SF-MPQ), Chronic Pain Grade Scale
(CPGS), Short Form-36 Bodily Pain Scale (SF-36 BPS), and Measure of
Intermittent and Constant Osteoarthritis Pain (ICOAP).
Arthritis Care and Research, 63(S11), S240-S252.
\doi{10.1002/acr.20543}

Hjermstad, M. J., Fayers, P. M., Haugen, D. F., et al. (2011).
Studies comparing Numerical Rating Scales, Verbal Rating Scales, and
Visual Analogue Scales for assessment of pain intensity in adults:
a systematic literature review.
Journal of Pain and Symptom Management, 41(6), 1073-1093.
\doi{10.1016/j.jpainsymman.2010.08.016}
}
