% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{brs_fit_var}
\alias{brs_fit_var}
\title{Fit a variable-dispersion beta interval regression model}
\usage{
brs_fit_var(
  formula,
  data,
  link = "logit",
  link_phi = "logit",
  hessian_method = c("numDeriv", "optim"),
  ncuts = 100L,
  lim = 0.5,
  repar = 2L,
  method = c("BFGS", "L-BFGS-B")
)
}
\arguments{
\item{formula}{A \code{\link[Formula]{Formula}}-style formula with
two parts: \code{y ~ x1 + x2 | z1 + z2}.}

\item{data}{Data frame.}

\item{link}{Mean link function (default \code{"logit"}).}

\item{link_phi}{Dispersion link function (default \code{"logit"}).}

\item{hessian_method}{Character: \code{"numDeriv"} or
\code{"optim"}.}

\item{ncuts}{Number of scale categories (default 100).}

\item{lim}{Uncertainty half-width (default 0.5).}

\item{repar}{Reparameterization scheme (default 2).}

\item{method}{Optimization method (default \code{"BFGS"}).}
}
\value{
An object of class \code{"brs"}.
}
\description{
Estimates the parameters of a beta regression model with
observation-specific dispersion governed by a second linear
predictor.  Both submodels are estimated jointly via maximum
likelihood, using the complete likelihood with mixed censoring.
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10),
  x2 = rep(c(0, 0, 1, 1), 5)
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brs_fit_var(y ~ x1 | x2, data = prep)
print(fit)
}

}
\references{
Lopes, J. E. (2023). \emph{Modelos de regressao beta para dados de escala}.
Master's dissertation, Universidade Federal do Parana, Curitiba.
URI: \url{https://hdl.handle.net/1884/86624}.

Hawker, G. A., Mian, S., Kendzerska, T., and French, M. (2011).
Measures of adult pain: Visual Analog Scale for Pain (VAS Pain),
Numeric Rating Scale for Pain (NRS Pain), McGill Pain Questionnaire (MPQ),
Short-Form McGill Pain Questionnaire (SF-MPQ), Chronic Pain Grade Scale
(CPGS), Short Form-36 Bodily Pain Scale (SF-36 BPS), and Measure of
Intermittent and Constant Osteoarthritis Pain (ICOAP).
Arthritis Care and Research, 63(S11), S240-S252.
\doi{10.1002/acr.20543}

Hjermstad, M. J., Fayers, P. M., Haugen, D. F., et al. (2011).
Studies comparing Numerical Rating Scales, Verbal Rating Scales, and
Visual Analogue Scales for assessment of pain intensity in adults:
a systematic literature review.
Journal of Pain and Symptom Management, 41(6), 1073-1093.
\doi{10.1016/j.jpainsymman.2010.08.016}
}
\keyword{internal}
