% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.R
\name{brs_cv}
\alias{brs_cv}
\title{K-fold cross-validation for brs models}
\usage{
brs_cv(formula, data, k = 5L, repeats = 1L, ...)
}
\arguments{
\item{formula}{Model formula passed to \code{\link{brs}}.}

\item{data}{Data frame.}

\item{k}{Number of folds.}

\item{repeats}{Number of repeated k-fold runs.}

\item{...}{Additional arguments forwarded to \code{\link{brs}}
(e.g., \code{repar}, \code{link}, \code{method}).}
}
\value{
A data frame with one row per fold and columns:
  \code{repeat}, \code{fold}, \code{n_train}, \code{n_test},
  \code{log_score}, \code{rmse_yt}, \code{mae_yt}, \code{converged},
  and \code{error}. The object has class \code{"brs_cv"}.
}
\description{
Performs repeated k-fold cross-validation for \code{\link{brs}} models.
}
\details{
The \code{log_score} is the mean log predictive contribution under the
complete likelihood contribution implied by each observation's
censoring type (\code{delta}).
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10),
  x2 = rep(c(0, 0, 1, 1), 5)
)
prep <- brs_prep(dat, ncuts = 100)
cv <- brs_cv(y ~ x1, data = prep, k = 3, repeats = 1)
cv
}

}
\references{
Lopes, J. E. (2023). \emph{Modelos de regressao beta para dados de escala}.
Master's dissertation, Universidade Federal do Parana, Curitiba.
URI: \url{https://hdl.handle.net/1884/86624}.

Hawker, G. A., Mian, S., Kendzerska, T., and French, M. (2011).
Measures of adult pain: Visual Analog Scale for Pain (VAS Pain),
Numeric Rating Scale for Pain (NRS Pain), McGill Pain Questionnaire (MPQ),
Short-Form McGill Pain Questionnaire (SF-MPQ), Chronic Pain Grade Scale
(CPGS), Short Form-36 Bodily Pain Scale (SF-36 BPS), and Measure of
Intermittent and Constant Osteoarthritis Pain (ICOAP).
Arthritis Care and Research, 63(S11), S240-S252.
\doi{10.1002/acr.20543}

Hjermstad, M. J., Fayers, P. M., Haugen, D. F., et al. (2011).
Studies comparing Numerical Rating Scales, Verbal Rating Scales, and
Visual Analogue Scales for assessment of pain intensity in adults:
a systematic literature review.
Journal of Pain and Symptom Management, 41(6), 1073-1093.
\doi{10.1016/j.jpainsymman.2010.08.016}
}
