% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{brs}
\alias{brs}
\title{Fit a beta interval regression model}
\usage{
brs(
  formula,
  data,
  link = "logit",
  link_phi = "logit",
  ncuts = 100L,
  lim = 0.5,
  repar = 2L,
  method = c("BFGS", "L-BFGS-B"),
  hessian_method = c("numDeriv", "optim")
)
}
\arguments{
\item{formula}{A \code{\link[Formula]{Formula}}-style formula with
two parts: \code{y ~ x1 + x2 | z1 + z2}.}

\item{data}{Data frame.}

\item{link}{Mean link function (default \code{"logit"}).}

\item{link_phi}{Dispersion link function (default \code{"logit"}).}

\item{ncuts}{Number of scale categories (default 100).}

\item{lim}{Uncertainty half-width (default 0.5).}

\item{repar}{Reparameterization scheme (default 2).}

\item{method}{Optimization method (default \code{"BFGS"}).}

\item{hessian_method}{Character: \code{"numDeriv"} or
\code{"optim"}.}
}
\value{
An object of class \code{"brs"}.
}
\description{
Unified interface that dispatches to \code{\link{brs_fit_fixed}}
(fixed dispersion) or \code{\link{brs_fit_var}} (variable
dispersion) based on the formula structure.
}
\details{
If the formula contains a \code{|} separator
(e.g., \code{y ~ x1 + x2 | z1}), the variable-dispersion model is
fitted; otherwise, a fixed-dispersion model is used.
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10),
  x2 = rep(c(0, 0, 1, 1), 5)
)
prep <- brs_prep(dat, ncuts = 100)
# Fixed dispersion
fit1 <- brs(y ~ x1, data = prep)
print(fit1)
# Variable dispersion
fit2 <- brs(y ~ x1 | x2, data = prep)
print(fit2)
}

}
\references{
Lopes, J. E. (2023). \emph{Modelos de regressao beta para dados de escala}.
Master's dissertation, Universidade Federal do Parana, Curitiba.
URI: \url{https://hdl.handle.net/1884/86624}.

Hawker, G. A., Mian, S., Kendzerska, T., and French, M. (2011).
Measures of adult pain: Visual Analog Scale for Pain (VAS Pain),
Numeric Rating Scale for Pain (NRS Pain), McGill Pain Questionnaire (MPQ),
Short-Form McGill Pain Questionnaire (SF-MPQ), Chronic Pain Grade Scale
(CPGS), Short Form-36 Bodily Pain Scale (SF-36 BPS), and Measure of
Intermittent and Constant Osteoarthritis Pain (ICOAP).
Arthritis Care and Research, 63(S11), S240-S252.
\doi{10.1002/acr.20543}

Hjermstad, M. J., Fayers, P. M., Haugen, D. F., et al. (2011).
Studies comparing Numerical Rating Scales, Verbal Rating Scales, and
Visual Analogue Scales for assessment of pain intensity in adults:
a systematic literature review.
Journal of Pain and Symptom Management, 41(6), 1073-1093.
\doi{10.1016/j.jpainsymman.2010.08.016}
}
