% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcq.R
\name{plot.prop_ss_output}
\alias{plot.prop_ss_output}
\title{Plot Proportion of SIR/SS Choices by k Value}
\usage{
\method{plot}{prop_ss_output}(
  x,
  ...,
  pt_shape = 21,
  pt_fill = "white",
  pt_size = 3,
  title = "Proportion of SIR/SS choices by k value",
  xlab = "k value rank",
  ylab = "Proportion of SS choices"
)
}
\arguments{
\item{x}{Output from the \code{prop_ss} function}

\item{...}{Additional arguments passed to \code{ggplot2::geom_point()}}

\item{pt_shape}{Shape of the points in the plot. Default is 21.}

\item{pt_fill}{Fill color of the points in the plot. Default is "white".}

\item{pt_size}{Size of the points in the plot. Default is 3.}

\item{title}{Title of the plot. Default is "Proportion of SIR/SS choices by k value".}

\item{xlab}{Label for the x-axis. Default is "k value rank".}

\item{ylab}{Label for the y-axis. Default is "Proportion of SS choices".}
}
\value{
A ggplot object.
}
\description{
This function creates a plot of the proportion of SIR/SS
choices by k value using the output of the \code{prop_ss} function.
}
\examples{
plot(prop_ss(mcq27))
}
