% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting.R
\name{results_dd}
\alias{results_dd}
\title{Extract Results from Delay-Discounting Model}
\usage{
results_dd(fit_dd_object)
}
\arguments{
\item{fit_dd_object}{A fitted delay-discounting model object of class \code{"fit_dd"}, created by the \code{fit_dd()} function.}
}
\value{
A tibble containing the following columns:
\itemize{
\item \code{id}: The participant or group ID (if applicable).
\item \code{term}: The model parameter (e.g., \code{k}).
\item \code{estimate}: The estimated value of the parameter.
\item \code{std.error}: The standard error of the parameter estimate.
\item \code{statistic}: The t-statistic for the parameter estimate.
\item \code{p.value}: The p-value for the parameter estimate.
\item \code{conf_low}: The lower bound of the 95\% confidence interval.
\item \code{conf_high}: The upper bound of the 95\% confidence interval.
\item \code{R2}: The coefficient of determination (\eqn{R^2}).
}
}
\description{
This function extracts model parameter estimates, fit statistics, and confidence intervals from a fitted delay-discounting model.
}
\examples{
data <- data.frame(
  id = rep(1:2, each = 6),
  x = rep(c(1, 7, 30, 90, 180, 365), 2),
  y = c(0.9, 0.5, 0.3, 0.2, 0.1, 0.05, 0.85, 0.55, 0.35, 0.15, 0.1, 0.05)
)
fit <- fit_dd(data, equation = "mazur", method = "two stage")
results_dd(fit)
}
