% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamPlotDispSeason.R
\name{gamPlotDispSeason}
\alias{gamPlotDispSeason}
\title{Plot censored gam fits vs. time}
\usage{
gamPlotDispSeason(
  gamResult = gamResult,
  analySpec = analySpec,
  fullModel = 2,
  seasAvgModel = 2,
  seasonalModel = 2,
  diffType = "regular",
  obserPlot = TRUE,
  interventionPlot = TRUE,
  seasAvgPlot = TRUE,
  seasAvgConfIntPlot = TRUE,
  seasAvgSigPlot = TRUE,
  fullModelPlot = TRUE,
  seasModelPlot = TRUE,
  BaseCurrentMeanPlot = TRUE,
  adjustedPlot = FALSE,
  gamSeasonFocus = TRUE
)
}
\arguments{
\item{gamResult}{output from procedure gamTest}

\item{analySpec}{analytical specifications}

\item{fullModel}{GAM # for displaying full GAM (e.g., 0, 1, 2)}

\item{seasAvgModel}{GAM # for displaying seasonally average GAM}

\item{seasonalModel}{GAM # for displaying seasonal GAM}

\item{diffType}{plot predicted baseline mean ('regular') or adjusted baseline mean ('adjusted')}

\item{obserPlot}{logical field indicating whether to plot observations}

\item{interventionPlot}{logical field indicating whether to plot interventions (e.g., method changes)}

\item{seasAvgPlot}{logical field indicating whether to plot seasonal average GAM}

\item{seasAvgConfIntPlot}{logical field indicating whether to plot confidence interval for seasonal average GAM}

\item{seasAvgSigPlot}{logical field indicating whether to plot significant increasing and decreasing trends for seasonal average GAM}

\item{fullModelPlot}{logical field indicating whether to plot full GAM}

\item{seasModelPlot}{logical field indicating whether to plot seasonal GAM}

\item{BaseCurrentMeanPlot}{logical field indicating whether to plot baseline and current mean}

\item{adjustedPlot}{logical field indicating whether to plot adjusted model}

\item{gamSeasonFocus}{logical field indicating whether to plot focus on season mean}
}
\description{
Plot censored gam fits vs. time
}
\examples{
\dontrun{
# Specify parameter and station to analyze
dep        <- 'do'
stat       <- 'CB5.4'
layer      <- 'B'

# Prepare data and set up specifications for analysis
dfr <- analysisOrganizeData (dataCensored)
df        <- dfr[[1]]
analySpec <- dfr[[2]]

# Apply gamTest 
gamResult <- gamTest(df, dep, stat, layer, analySpec=analySpec)
gamPlotDisp(gamResult = gamResult, analySpec = analySpec,
            fullModel = 2, seasAvgModel = 2, seasonalModel = 2,
            diffType = "regular", obserPlot = TRUE, interventionPlot = TRUE,
            seasAvgPlot = TRUE, seasAvgConfIntPlot = FALSE,
            seasAvgSigPlot = FALSE, fullModelPlot = TRUE, seasModelPlot = TRUE,
            BaseCurrentMeanPlot = FALSE, adjustedPlot = FALSE)

# Apply gamTestSeason
gamResult2 <- gamTestSeason(df, dep, stat, layer, analySpec=analySpec,
                            gamSeasonPlot = c("7/15-8/15", "purple", "range"))
gamPlotDispSeason(gamResult = gamResult2, analySpec = analySpec,
                  fullModel = 2, seasAvgModel = 2, seasonalModel = 2,
                  diffType = "regular", obserPlot = TRUE, interventionPlot = TRUE,
                  seasAvgPlot = TRUE, seasAvgConfIntPlot = FALSE,
                  seasAvgSigPlot = FALSE, fullModelPlot = FALSE, seasModelPlot = FALSE,
                  BaseCurrentMeanPlot = TRUE, adjustedPlot = FALSE, gamSeasonFocus = TRUE)
}
}
\seealso{
\code{\link{gamPlotDisp}}
}
