% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PMF.R
\name{PMF.summary}
\alias{PMF.summary}
\title{Returns summary of a PMF object}
\usage{
PMF.summary(pmf, Ltoll = .TOLL, Rtoll = .RTOLL)
}
\arguments{
\item{pmf}{the PMF object.}

\item{Ltoll}{used for computing the min of the PMF: the min is the smallest value
with probability greater than Ltoll (default: 1e-15)}

\item{Rtoll}{used for computing the max of the PMF: the max is the largest value
with probability greater than Rtoll (default: 1e-9)}
}
\value{
A summary data.frame
}
\description{
Returns the summary (min, max, IQR, median, mean) of the PMF specified by \code{pmf}.
}
\examples{
library(bayesRecon)

# Let's build the pmf of a Binomial distribution with parameters n and p
n <- 10
p <- 0.6 
pmf_binomial <- apply(matrix(seq(0,10)),MARGIN=1,FUN=function(x) dbinom(x,size=n,prob=p))

# Print the summary of this distribution
PMF.summary(pmf=pmf_binomial)


}
\seealso{
\code{\link[=PMF.get_mean]{PMF.get_mean()}}, \code{\link[=PMF.get_var]{PMF.get_var()}}, \code{\link[=PMF.get_quantile]{PMF.get_quantile()}}, \code{\link[=PMF.sample]{PMF.sample()}}
}
