% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_robustness.R
\name{prior_robustness}
\alias{prior_robustness}
\alias{print.prior_robustness}
\title{Prior Robustness Analysis}
\usage{
prior_robustness(
  model,
  prior_specifications,
  parameters,
  perturbation_direction = "expand",
  dimensions = c(0.5, 1, 2, 4),
  comparison_metric = "KL",
  credible_level = 0.95,
  plot = TRUE,
  ...
)

\method{print}{prior_robustness}(x, ...)
}
\arguments{
\item{model}{A fitted brmsfit object}

\item{prior_specifications}{List of alternative prior specifications.
Each element should be a prior() object or named list of priors.}

\item{parameters}{Character vector of parameters to analyze}

\item{perturbation_direction}{Character: "expand", "contract", or "shift"}

\item{dimensions}{Numeric vector of perturbation magnitudes (default: c(0.5, 1, 2, 4))}

\item{comparison_metric}{One of "KL", "Wasserstein", "correlation", "coverage"}

\item{credible_level}{Numeric. Credible interval level (default: 0.95)}

\item{plot}{Logical. Generate visualizations (default: TRUE)}

\item{...}{Additional arguments}

\item{x}{Object of class \code{prior_robustness} (for print method).}
}
\value{
Object of class \code{prior_robustness} containing:
\itemize{
\item \code{sensitivity_surfaces} - Multi-dimensional sensitivity results
\item \code{robustness_index} - Composite robustness score
\item \code{concerning_parameters} - Parameters with low robustness
\item \code{recommendations} - Suggested prior refinements
}
}
\description{
Comprehensive assessment of posterior robustness to alternative
prior specifications using multiple sensitivity dimensions.
}
