% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel.R
\name{kernel-arith}
\alias{kernel-arith}
\alias{*.kernel}
\alias{+.kernel}
\title{Kernel arithmetic}
\usage{
\method{*}{kernel}(x, k2)

\method{+}{kernel}(k1, k2)
}
\arguments{
\item{x}{a numeric or a \code{kernel} function}

\item{k2}{a \code{kernel} function}

\item{k1}{a \code{kernel} function}
}
\value{
A new kernel function, with class \code{c("kernel", "function")}.
}
\description{
Kernel functions (see \code{\link[=kernels]{?kernels}}) may be multiplied by constants,
multiplied by each other, or added together.
}
\examples{
x = seq(-1, 1, 0.5)
k = k_rbf()
k2 = k_per(scale=0.2, period=0.3)

k_add = k2 + 0.5*k
print(k_add)
image(k_add(x, x))

}
\concept{kernels}
