% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlb_team_affiliates.R
\name{mlb_team_affiliates}
\alias{mlb_team_affiliates}
\title{\strong{MLB Team Affiliates}}
\usage{
mlb_team_affiliates(team_ids = NULL, sport_ids = NULL, season = NULL)
}
\arguments{
\item{team_ids}{The team_id(s) to return affiliates data for.}

\item{sport_ids}{The sport_id to return team affiliates information for.}

\item{season}{The season to return team affiliates data for the particular season.}
}
\value{
Returns a tibble with the following columns\tabular{ll}{
   col_name \tab types \cr
   all_star_status \tab character \cr
   team_id \tab integer \cr
   team_full_name \tab character \cr
   link \tab character \cr
   season \tab integer \cr
   team_code \tab character \cr
   file_code \tab character \cr
   team_abbreviation \tab character \cr
   team_name \tab character \cr
   location_name \tab character \cr
   first_year_of_play \tab character \cr
   short_name \tab character \cr
   franchise_name \tab character \cr
   club_name \tab character \cr
   active \tab logical \cr
   parent_org_name \tab character \cr
   parent_org_id \tab integer \cr
   spring_league_id \tab integer \cr
   spring_league_name \tab character \cr
   spring_league_link \tab character \cr
   spring_league_abbreviation \tab character \cr
   venue_id \tab integer \cr
   venue_name \tab character \cr
   venue_link \tab character \cr
   spring_venue_id \tab integer \cr
   spring_venue_link \tab character \cr
   league_id \tab integer \cr
   league_name \tab character \cr
   league_link \tab character \cr
   division_id \tab integer \cr
   division_name \tab character \cr
   division_link \tab character \cr
   sport_id \tab integer \cr
   sport_link \tab character \cr
   sport_name \tab character \cr
}
}
\description{
\strong{MLB Team Affiliates}
}
\examples{
\donttest{
  try(mlb_team_affiliates(team_ids = 147))
}
}
