% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{check_method}
\alias{check_method}
\title{Check each method body in an object if it contains names that do not
explicitly bind to a specified namespace via \code{::}.}
\usage{
check_method(env, symbol_name, target_namespace)
}
\arguments{
\item{env}{Environment. An environment.}

\item{symbol_name}{Character. Names that want to be detected.}

\item{target_namespace}{Character. Name of the package that symbols belong
to.}
}
\value{
No return value, called for side effects.
}
\description{
Method body could contain names like "mutate" that are from packages,
it usually would not be a problem as long as the package namespace is in
the search path or it is available in the parent environment of the object.
However, if the package is not loaded via functions like \code{library()} and
the name used in the method body is unavailable in the parent environment of
the object, then an error may be raised saying that "object \code{name} not found"
when the method is run. \cr \cr This function helps detect this kind of
problems. Users needs to specify the names they want to detect, and specify
the package they belong to.
}
\examples{

e <- new.env()
register_method(e, test = function() cli_alert_info("test"))
check_method(e, "cli_alert_info", "cli")

register_method(e, test = function() cli::cli_alert_info("test"))
check_method(e, "cli_alert_info", "cli")

}
