% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oop.R
\name{as_bandicoot_oop}
\alias{as_bandicoot_oop}
\title{Turn an environment into a \code{bandicoot_oop} object}
\usage{
as_bandicoot_oop(
  env,
  ..class.. = NULL,
  ..type.. = NULL,
  ..instantiated.. = NULL,
  overwrite_container = FALSE,
  register = FALSE,
  in_place = FALSE,
  container_name = "..method_env..",
  self_name = "self"
)
}
\arguments{
\item{env}{An environment.}

\item{..class..}{Character. A series of class names.}

\item{..type..}{Character. The class name of this object.}

\item{..instantiated..}{Boolean. Whether this object is an instance.}

\item{overwrite_container}{Boolean. Whether or not to overwrite the container.}

\item{register}{Boolean. Whether or not to register functions if there are any.}

\item{in_place}{Boolean. Whether or not to modify the environment in-place.
If not, a new environment will be created.}

\item{container_name}{Character. Name of the container.}

\item{self_name}{Character. Name of the self reference.}
}
\value{
A Boolean value.
}
\description{
This function tries to turn an environment into a \code{bandicoot_oop} object.
}
\examples{

e <- new.env()
e$a <- function() self

as_bandicoot_oop(e,
                 ..class.. = "test",
                 ..type.. = "test",
                 ..instantiated.. = FALSE,
                 register = TRUE,
                 in_place = TRUE)

e
e$a()

}
