% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enable_kms_rotation.R
\name{enable_kms_rotation}
\alias{enable_kms_rotation}
\alias{disable_kms_rotation}
\alias{get_kms_rotation}
\title{Enable/Disable Key Rotation}
\usage{
enable_kms_rotation(key, ...)

disable_kms_rotation(key, ...)

get_kms_rotation(key, ...)
}
\arguments{
\item{key}{A character string specifying a key ID, Amazon Resource Name (ARN), alias name, or alias ARN. When using an alias name, prefix it with \dQuote{alias/}.}

\item{\dots}{Additional arguments passed to \code{\link{kmsHTTP}}.}
}
\description{
Enable or disable a encryption key rotation
}
\examples{
\dontrun{
  # create key
  k <- create_kms_key(description = "example")
  
  # enable rotation
  enable_kms_rotation(k)
  
  # disable rotation
  disable_kms_rotation(k)
  
  # confirm rotation is disabled
  get_kms_rotation(k)
  
  # delete in 7 days
  delete_kms_key(k)
}
}
\seealso{
\code{\link{create_kms_key}}, \code{\link{list_kms_keys}}
}
