% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SamplingVAE.R
\name{Decoder_weights}
\alias{Decoder_weights}
\title{Extract decoder-only weights from a trained Keras model}
\usage{
Decoder_weights(
  encoder_layers,
  trained_model,
  lip_enc,
  pi_enc,
  prior_learn,
  BNenc_layers,
  learn_BN
)
}
\arguments{
\item{encoder_layers}{Integer. Number of encoder layers (used to compute split index).}

\item{trained_model}{Keras model. Typically \code{training$trained_model}.}

\item{lip_enc}{Integer (0/1). Whether spectral normalization was used in the encoder.}

\item{pi_enc}{Integer. Power iterations used in encoder spectral normalization.}

\item{prior_learn}{Character. \code{"fixed"} for fixed prior; any other value implies learnable MoG.}

\item{BNenc_layers}{Integer. Number of encoder BN layers (affects split index).}

\item{learn_BN}{Integer (0/1). Whether BN layers learned scale and center.}
}
\value{
A \code{list()} of decoder weight tensors in order, suitable for \code{set_weights()}.
}
\description{
Pulls just the \strong{decoder} weights from \code{keras::get_weights(trained_model)},
skipping encoder parameters and (if used) the final trainable tensors from a
learnable mixture-of-Gaussians (MoG) prior (means, log_vars, and weight logits).
}
\details{
\itemize{
\item When \code{prior_learn != "fixed"}, the final \strong{three} tensors are assumed to belong to
the learnable MoG prior (\code{mog_means}, \code{mog_log_vars}, \code{mog_weights_logit}) and are excluded.
\item The split index math mirrors \code{\link[=Encoder_weights]{Encoder_weights()}} and assumes the standard AutoTab graph wiring.
\item All model weights can always be accessed directly using
\code{keras::get_weights(trained_model)}. This function is provided as a
convenience tool within AutoTab to streamline decoder reconstruction but
is not the only method available.
}
}
\examples{
decoder_info <- list(
  list("dense", 80, "relu"),
  list("dense", 100, "relu")
)
\donttest{
if (reticulate::py_module_available("tensorflow") &&
    exists("training")) {
weights_decoder <- Decoder_weights(
  encoder_layers = 2,
  trained_model  = training$trained_model,  #where training = VAE_train(...)
  lip_enc        = 0,
  pi_enc         = 0,
  prior_learn    = "fixed",
  BNenc_layers   = 0,
  learn_BN       = 0
)
}
}
}
\seealso{
\code{\link[=decoder_model]{decoder_model()}}, \code{\link[=Encoder_weights]{Encoder_weights()}}, \code{\link[=VAE_train]{VAE_train()}}
}
