% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{convolve_events}
\alias{convolve_events}
\title{convolve_events}
\usage{
convolve_events(
  model,
  tr,
  max_duration,
  hrf = "spm",
  t = 32,
  p_boynton = c(2.25, 1.25, 2),
  p_spm = c(6, 16, 1, 1, 6, 0),
  f = 100
)
}
\arguments{
\item{model}{A data frame containing information about the model to use
and its events (event, start_time and duration).}

\item{tr}{MRI's repetition time.}

\item{max_duration}{Maximum duration of the signal.}

\item{hrf}{Method to use for HRF generation, can be "boynton" or "spm".}

\item{t}{The t parameter for Boynton or SPM HRF generation.}

\item{p_boynton}{Parameters for the Boynton's HRF.}

\item{p_spm}{Parameters for the SPM HRF.}

\item{f}{Upsampling factor.}
}
\value{
Returns a list with the convolved signal and time series.
}
\description{
A helper function for convolving events of a model with a
generated HRF signal.
}
