% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AtomEntry.R
\docType{class}
\name{AtomEntry}
\alias{AtomEntry}
\title{Atom Entry class}
\format{
\code{ \link[R6]{R6Class}} object.
}
\value{
Object of \code{ \link[R6]{R6Class}} for modelling an Atom Entry
}
\description{
This class models an atom Entry
}
\details{
AtomEntry
}
\examples{
 \dontrun{
  #encoding
  atom <- AtomEntry$new()
  atom$setId("my-atom-entry")
  atom$setTitle("My Atom feed entry")
  atom$setSummary("My Atom feed entry very comprehensive abstract")
  author1 <- AtomAuthor$new(
    name = "John Doe",
    uri = "http://www.atomxml.com/johndoe",
    email = "johndoe@atom4R.com"
  )
  atom$addAuthor(author1)
  author2 <- AtomAuthor$new(
    name = "John Doe's sister",
    uri = "http://www.atomxml.com/johndoesister",
    email = "johndoesister@atom4R.com"
  )
  atom$addAuthor(author2)
  contrib1 <- AtomContributor$new(
    name = "Contrib1",
    uri = "http://www.atomxml.com/contrib1",
    email = "contrib1@atom4R.com"
  )
  atom$addContributor(contrib1)
  contrib2 <- AtomContributor$new(
    name = "Contrib2",
    uri = "http://www.atomxml.com/contrib2",
    email = "contrib2@atom4R.com"
  )
  atom$addContributor(contrib2)
  atom$addCategory("draft", "dataset")
  atom$addCategory("world", "spatial")
  atom$addCategory("fisheries", "domain")

  xml <- atom$encode()
 }

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{Entry}
\keyword{atom}
\section{Super classes}{
\code{\link[atom4R:atom4RLogger]{atom4R::atom4RLogger}} -> \code{\link[atom4R:AtomAbstractObject]{atom4R::AtomAbstractObject}} -> \code{AtomEntry}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{id}}{identifier}

\item{\code{updated}}{Update date/time}

\item{\code{published}}{Publication date/time}

\item{\code{title}}{Title}

\item{\code{summary}}{Summary}

\item{\code{rights}}{Rights}

\item{\code{source}}{Source}

\item{\code{author}}{Author(s)}

\item{\code{contributor}}{Contributor(s)}

\item{\code{category}}{Category}

\item{\code{content}}{Content}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AtomEntry-new}{\code{AtomEntry$new()}}
\item \href{#method-AtomEntry-setId}{\code{AtomEntry$setId()}}
\item \href{#method-AtomEntry-setUpdated}{\code{AtomEntry$setUpdated()}}
\item \href{#method-AtomEntry-setPublished}{\code{AtomEntry$setPublished()}}
\item \href{#method-AtomEntry-setTitle}{\code{AtomEntry$setTitle()}}
\item \href{#method-AtomEntry-setSummary}{\code{AtomEntry$setSummary()}}
\item \href{#method-AtomEntry-setRights}{\code{AtomEntry$setRights()}}
\item \href{#method-AtomEntry-setSource}{\code{AtomEntry$setSource()}}
\item \href{#method-AtomEntry-addAuthor}{\code{AtomEntry$addAuthor()}}
\item \href{#method-AtomEntry-delAuthor}{\code{AtomEntry$delAuthor()}}
\item \href{#method-AtomEntry-addContributor}{\code{AtomEntry$addContributor()}}
\item \href{#method-AtomEntry-delContributor}{\code{AtomEntry$delContributor()}}
\item \href{#method-AtomEntry-addCategory}{\code{AtomEntry$addCategory()}}
\item \href{#method-AtomEntry-delCategory}{\code{AtomEntry$delCategory()}}
\item \href{#method-AtomEntry-addLink}{\code{AtomEntry$addLink()}}
\item \href{#method-AtomEntry-delLink}{\code{AtomEntry$delLink()}}
\item \href{#method-AtomEntry-setContent}{\code{AtomEntry$setContent()}}
\item \href{#method-AtomEntry-clone}{\code{AtomEntry$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="atom4RLogger" data-id="ERROR"><a href='../../atom4R/html/atom4RLogger.html#method-atom4RLogger-ERROR'><code>atom4R::atom4RLogger$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="atom4RLogger" data-id="INFO"><a href='../../atom4R/html/atom4RLogger.html#method-atom4RLogger-INFO'><code>atom4R::atom4RLogger$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="atom4RLogger" data-id="WARN"><a href='../../atom4R/html/atom4RLogger.html#method-atom4RLogger-WARN'><code>atom4R::atom4RLogger$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="atom4RLogger" data-id="logger"><a href='../../atom4R/html/atom4RLogger.html#method-atom4RLogger-logger'><code>atom4R::atom4RLogger$logger()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="addListElement"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-addListElement'><code>atom4R::AtomAbstractObject$addListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="contains"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-contains'><code>atom4R::AtomAbstractObject$contains()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="createElement"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-createElement'><code>atom4R::AtomAbstractObject$createElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="decode"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-decode'><code>atom4R::AtomAbstractObject$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="delListElement"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-delListElement'><code>atom4R::AtomAbstractObject$delListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="encode"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-encode'><code>atom4R::AtomAbstractObject$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="getClass"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-getClass'><code>atom4R::AtomAbstractObject$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="getClassName"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-getClassName'><code>atom4R::AtomAbstractObject$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="getNamespace"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-getNamespace'><code>atom4R::AtomAbstractObject$getNamespace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="getNamespaceDefinition"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-getNamespaceDefinition'><code>atom4R::AtomAbstractObject$getNamespaceDefinition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="getRootElement"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-getRootElement'><code>atom4R::AtomAbstractObject$getRootElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="getXmlElement"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-getXmlElement'><code>atom4R::AtomAbstractObject$getXmlElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="isDocument"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-isDocument'><code>atom4R::AtomAbstractObject$isDocument()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="isFieldInheritedFrom"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-isFieldInheritedFrom'><code>atom4R::AtomAbstractObject$isFieldInheritedFrom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="print"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-print'><code>atom4R::AtomAbstractObject$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="save"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-save'><code>atom4R::AtomAbstractObject$save()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="setIsDocument"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-setIsDocument'><code>atom4R::AtomAbstractObject$setIsDocument()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="validate"><a href='../../atom4R/html/AtomAbstractObject.html#method-AtomAbstractObject-validate'><code>atom4R::AtomAbstractObject$validate()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomEntry-new"></a>}}
\if{latex}{\out{\hypertarget{method-AtomEntry-new}{}}}
\subsection{Method \code{new()}}{
Initializes an \link{AtomEntry}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$new(xml = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link[XML]{XMLInternalNode-class} from \pkg{XML}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomEntry-setId"></a>}}
\if{latex}{\out{\hypertarget{method-AtomEntry-setId}{}}}
\subsection{Method \code{setId()}}{
Set ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$setId(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{id}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomEntry-setUpdated"></a>}}
\if{latex}{\out{\hypertarget{method-AtomEntry-setUpdated}{}}}
\subsection{Method \code{setUpdated()}}{
Set updated date
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$setUpdated(updated)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{updated}}{object of class \code{Date} or \code{POSIXt}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomEntry-setPublished"></a>}}
\if{latex}{\out{\hypertarget{method-AtomEntry-setPublished}{}}}
\subsection{Method \code{setPublished()}}{
Set published date
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$setPublished(published)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{published}}{object of class \code{Date} or \code{POSIXt}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomEntry-setTitle"></a>}}
\if{latex}{\out{\hypertarget{method-AtomEntry-setTitle}{}}}
\subsection{Method \code{setTitle()}}{
Set title
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$setTitle(title, type = "text")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{title}}{title}

\item{\code{type}}{type. Default is "text"}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomEntry-setSummary"></a>}}
\if{latex}{\out{\hypertarget{method-AtomEntry-setSummary}{}}}
\subsection{Method \code{setSummary()}}{
Set summary
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$setSummary(summary, type = "text")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{summary}}{summary}

\item{\code{type}}{type. Default is "text"}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomEntry-setRights"></a>}}
\if{latex}{\out{\hypertarget{method-AtomEntry-setRights}{}}}
\subsection{Method \code{setRights()}}{
Set rights
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$setRights(rights, type = "text")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rights}}{rights}

\item{\code{type}}{type. Default is "text"}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomEntry-setSource"></a>}}
\if{latex}{\out{\hypertarget{method-AtomEntry-setSource}{}}}
\subsection{Method \code{setSource()}}{
Set source
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$setSource(source, type = "text")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source}}{source}

\item{\code{type}}{type. Default is "text"}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomEntry-addAuthor"></a>}}
\if{latex}{\out{\hypertarget{method-AtomEntry-addAuthor}{}}}
\subsection{Method \code{addAuthor()}}{
Adds author
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$addAuthor(author)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{author}}{object of class \link{AtomAuthor}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomEntry-delAuthor"></a>}}
\if{latex}{\out{\hypertarget{method-AtomEntry-delAuthor}{}}}
\subsection{Method \code{delAuthor()}}{
Deletes author
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$delAuthor(author)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{author}}{object of class \link{AtomAuthor}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomEntry-addContributor"></a>}}
\if{latex}{\out{\hypertarget{method-AtomEntry-addContributor}{}}}
\subsection{Method \code{addContributor()}}{
Adds contributor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$addContributor(contributor)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{contributor}}{object of class \link{AtomContributor}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomEntry-delContributor"></a>}}
\if{latex}{\out{\hypertarget{method-AtomEntry-delContributor}{}}}
\subsection{Method \code{delContributor()}}{
Deletes contributor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$delContributor(contributor)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{contributor}}{object of class \link{AtomContributor}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomEntry-addCategory"></a>}}
\if{latex}{\out{\hypertarget{method-AtomEntry-addCategory}{}}}
\subsection{Method \code{addCategory()}}{
Adds category
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$addCategory(value, term, scheme = NULL, label = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{value}

\item{\code{term}}{term}

\item{\code{scheme}}{scheme}

\item{\code{label}}{label}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomEntry-delCategory"></a>}}
\if{latex}{\out{\hypertarget{method-AtomEntry-delCategory}{}}}
\subsection{Method \code{delCategory()}}{
Deletes category
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$delCategory(value, term, scheme = NULL, label = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{value}

\item{\code{term}}{term}

\item{\code{scheme}}{scheme}

\item{\code{label}}{label}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomEntry-addLink"></a>}}
\if{latex}{\out{\hypertarget{method-AtomEntry-addLink}{}}}
\subsection{Method \code{addLink()}}{
Adds link
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$addLink(link, rel = "alternate", type = "text/html")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{link}}{link}

\item{\code{rel}}{relation. Default is "alternate"}

\item{\code{type}}{type. Default is "text/html"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomEntry-delLink"></a>}}
\if{latex}{\out{\hypertarget{method-AtomEntry-delLink}{}}}
\subsection{Method \code{delLink()}}{
Deletes link
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$delLink(link, rel = "alternate", type = "text/html")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{link}}{link}

\item{\code{rel}}{relation. Default is "alternate"}

\item{\code{type}}{type. Default is "text/html"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomEntry-setContent"></a>}}
\if{latex}{\out{\hypertarget{method-AtomEntry-setContent}{}}}
\subsection{Method \code{setContent()}}{
Set content
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$setContent(content)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{content}}{content}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomEntry-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AtomEntry-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
