#' asymLD: a package for computing asymmetric Linkage Disequilibrium (ALD) between two polymorphic genetic loci
#'
#' Computes asymmetric LD measures (ALD) for polymorphic genetic data. 
#' These measures are identical to the correlation measure (r) for bi-allelic data.
#' 
#' @details
#'  \tabular{ll}{
#'  Package: \tab asymLD\cr
#'  Type: \tab Package\cr
#'  Version: \tab 0.1\cr
#'  Date: \tab 2015-03-13\cr
#'  License: \tab GPL-2\cr
#'  }
#' 
#' @aliases asymLD
#' @section asymLD functions:
#' The function compute.ALD() calculates asymmetric LD for haplotype frequency data.
#' The function compute.AShomz() calculates allele specific homozygosity values for haplotype frequency data.
#'
#' @docType package
#' @name asymLD-package
#' @references Thomson G, Single RM. Conditional Asymmetric Linkage Disequilibrium (ALD): Extending the Bi-Allelic r^2 Measure. Genetics. 2014  198(1):321-331. PMID:25023400
#' @keywords linkage disequilibrium
#' @keywords LD
#' @keywords genetics
#' 
NULL
