% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2D.R
\name{runif_annulus}
\alias{runif_annulus}
\title{Uniform Sampling from Annulus}
\usage{
runif_annulus(n, rmax = 1, rmin = 0.5)
}
\arguments{
\item{n}{number of points to sample}

\item{rmax}{radius of outer circle of annulus}

\item{rmin}{radius of inner circle of annulus}
}
\value{
n by 2 matrix of points sampled
}
\description{
Returns points uniformly sampled from annulus in plane
}
\examples{
# Sample 100 points from annulus with rmax=1 and rmin=0.5
runif_annulus(100)
# Sample 100 points from annulus with rmax=0.75 and rmin=0.25
runif_annulus(100, 0.75, 0.25)
}
