% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_trace.R
\name{tidy_trace}
\alias{tidy_trace}
\title{Tidy up a trace_asco output nested list}
\usage{
tidy_trace(trace)
}
\arguments{
\item{trace}{a nested list output from \code{\link[=trace_asco]{trace_asco()}}}
}
\value{
A tidy \CRANpkg{data.table} of \code{\link[=trace_asco]{trace_asco()}} output.
}
\description{
Creates a tidy \CRANpkg{data.table} from the output of \code{\link[=trace_asco]{trace_asco()}}.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

Newmarracarra <-
   read.csv(system.file("extdata",
            "1998_Newmarracarra_weather_table.csv", package = "ascotraceR"))
station_data <-
   system.file("extdata", "stat_dat.csv", package = "ascotraceR")

weather_dat <- format_weather(
   x = Newmarracarra,
   POSIXct_time = "Local.Time",
   temp = "mean_daily_temp",
   ws = "ws",
   wd_sd = "wd_sd",
   rain = "rain_mm",
   wd = "wd",
   station = "Location",
   time_zone = "Australia/Perth",
   lonlat_file = station_data)

traced <- trace_asco(
  weather = weather_dat,
  paddock_length = 20,
  paddock_width = 20,
  initial_infection = "1998-06-10",
  sowing_date = as.POSIXct("1998-06-09"),
  harvest_date = as.POSIXct("1998-06-09") + lubridate::ddays(100),
  time_zone = "Australia/Perth",
  primary_infection_foci = "centre")

tidied <- tidy_trace(traced)

# take a look at the infectious growing points on day 102
library(ggplot2)
ggplot(data = subset(tidied, i_day == 102),
       aes(x = x, y = y, fill = infectious_gp)) +
  geom_tile()
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=summarise_trace]{summarise_trace()}}, \code{\link[=trace_asco]{trace_asco()}}
}
