% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arlc_get_network_dataset.R
\name{arlc_get_network_dataset}
\alias{arlc_get_network_dataset}
\title{Get Network Dataset}
\usage{
arlc_get_network_dataset(file_path, label)
}
\arguments{
\item{file_path}{The file path to the GML file to be loaded.}

\item{label}{A label for the graph.}
}
\value{
A list containing the graph object and its properties: total edges, total nodes, and average degree.
}
\description{
This function reads a network dataset from a GML file, assigns node names, and calculates
various properties of the graph such as total edges, total nodes, and average degree.
}
\details{
This function loads a network dataset from a specified GML file and computes basic graph properties.
}
\examples{
\donttest{
# Create a sample transactions dataset
sample_gml_file <- system.file("extdata", "karate.gml", package = "arlclustering")
loaded_karate <- arlc_get_network_dataset(sample_gml_file, "Karate Club")
message(loaded_karate$graph)
message(loaded_karate$graphLabel)
message(loaded_karate$totalEdges)
message(loaded_karate$graphEdges)
message(loaded_karate$totalNodes)
message(loaded_karate$graphNodes)
message(loaded_karate$averageDegree)
}
}
