% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arlc_gen_gross_rules.R
\name{arlc_gen_gross_rules}
\alias{arlc_gen_gross_rules}
\title{Get Gross Rules}
\usage{
arlc_gen_gross_rules(transactions, minSupp, minConf, minLenRules, maxLenRules)
}
\arguments{
\item{transactions}{A transactions object.}

\item{minSupp}{Minimum support threshold.}

\item{minConf}{Minimum confidence threshold.}

\item{minLenRules}{Minimum length of rules.}

\item{maxLenRules}{Maximum length of rules.}
}
\value{
A set of gross association rules.
}
\description{
This function generates gross association rules from transactions.
}
\examples{
\donttest{
library(arlclustering)
# Create a sample transactions dataset
sample_gml_file <- system.file("extdata", "karate.gml", package = "arlclustering")
g <- arlc_get_network_dataset(sample_gml_file, "Karate Club")
trans <- arlc_gen_transactions(g$graph)
supportRange <- seq(0.1, 0.2, by = 0.1)
Conf <- 0.5
params <- arlc_get_apriori_thresholds(trans, supportRange, Conf)
grossRules <- arlc_gen_gross_rules(trans, params$minSupp, params$minConf, 1, params$lenRules)
}
}
