% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/statistics.R
\docType{methods}
\name{resample_multinomial}
\alias{resample_multinomial}
\alias{resample_multinomial-method}
\alias{resample_multinomial,numeric-method}
\title{Draw Multinomial Random Sample}
\usage{
resample_multinomial(object, ...)

\S4method{resample_multinomial}{numeric}(object, n, size = sum(object), ...)
}
\arguments{
\item{object}{A length-\eqn{k} \code{\link{integer}} vector, specifying the probability
for the \eqn{k} classes; is internally normalized to sum to 1.}

\item{...}{Currently not used.}

\item{n}{A non-negative \code{\link{integer}} specifying the number of random vector
to draw.}

\item{size}{A non-negative \code{\link{integer}} specifying the sample size.}
}
\value{
A \code{numeric} \code{\link{matrix}} with \code{n} rows and \code{k} columns.
}
\description{
Draws a random (sub)sample from a multinomial distribution.
}
\examples{
## Uniform distribution
x <- rnorm(20)
resample_uniform(x, n = 10)

## Multinomial distribution
x <- sample(1:100, 20, TRUE)
resample_multinomial(x, n = 10)
}
\seealso{
\code{\link[stats:Multinom]{stats::rmultinom()}}

Other resampling methods: 
\code{\link{bootstrap}()},
\code{\link{jackknife}()},
\code{\link{resample_uniform}()}
}
\author{
N. Frerebeau
}
\concept{resampling methods}
