% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/archivistOptions.R
\name{aoptions}
\alias{aoptions}
\title{Default Options for Archivist}
\usage{
aoptions(key, value = NULL, unset = FALSE)
}
\arguments{
\item{key}{A character denoting name of the parameter.}

\item{value}{New value for the 'key' parameter.}

\item{unset}{Set to \code{TRUE} if want to set parameter to \code{NULL}, 
i.e. when unsetting Repository \code{aoptions('repoDir', NULL, T)}.}
}
\value{
The function returns value that corresponds to a selected key.
}
\description{
The function \code{aoptions} sets and gets default options
for other \code{archivist} functions.
}
\details{
The function \code{aoptions} with two parameters sets default \code{value} 
of \code{key} parameter for other \code{archivist} functions. The function
\code{aoptions} with one parameter returns value (stored in an internal environment))
of the given \code{key} parameter.
}
\section{Contact}{

 
Bug reports and feature requests can be sent to 
\href{https://github.com/pbiecek/archivist/issues}{https://github.com/pbiecek/archivist/issues}
}

\examples{
\dontrun{
# data.frame object
# data(iris)


## EXAMPLE 1 : SET default local repository using aoptions() function.

# creating example repository
exampleRepoDir <- tempfile()
createLocalRepo(exampleRepoDir)

# "repodDir" parameter in each archivist function will be default and set to exampleRepoDir.
aoptions(key = "repoDir", value = exampleRepoDir)

data(iris)
data(swiss)
# From this moment repoDir parameter may be ommitted in the following functions
saveToLocalRepo(iris)
saveToLocalRepo(swiss) 
showLocalRepo()
showLocalRepo(method = "tags")
zipLocalRepo()
file.remove(file.path(getwd(), "repository.zip"))
iris2 <- loadFromLocalRepo( "ff575c2" , value = TRUE)
searchInLocalRepo("name:i", fixed = F)
getTagsLocal("ff575c261c949d073b2895b05d1097c3")
rmFromLocalRepo("4c43f")
showLocalRepo()
summaryLocalRepo()

# REMEMBER that in deleteRepo you MUST specify repoDir parameter!
# deleteLocalRepo doesn't take setLocalRepo's settings into consideration
deleteLocalRepo( exampleRepoDir, deleteRoot = TRUE)
rm( exampleRepoDir )

## EXAMPLE 2 : SET default Github repository using aoptions() function.
aoptions(key = "user", value = "pbiecek")
aoptions(key = "repo", value = "archivist")

# From this moment user and repo parameters may be ommitted in the following functions:
showRemoteRepo() 
loadFromRemoteRepo( "ff575c261c949d073b2895b05d1097c3")
this <- loadFromRemoteRepo( "ff", value = T)
file.remove(file.path(getwd(), "repository.zip")) # We can remove this zip file
searchInRemoteRepo( "name:", fixed= FALSE)
getTagsGithub("ff575c261c949d073b2895b05d1097c3")
summaryRemoteRepo( )
searchInRemoteRepo( pattern=c("varname:Sepal.Width", "class:lm", "name:myplot123"), 
                         intersect = FALSE ) 
## EXAMPLE 3 : SET default Github repository using aoptions() function.
showRemoteRepo('Museum', 'MarcinKosinski', subdir = 'ex1')
aoptions('repo', 'Museum')
aoptions('user', 'MarcinKosinski')
aoptions('subdir', 'ex1')
aoptions('branch', 'master')
showRemoteRepo()
showRemoteRepo(subdir = 'ex2')

aoptions('subdir')

## EXAMPLE 4 : SET sha256 as a hasing algorithm
aoptions("hashFunction", value = "sha256")
exampleRepoDir <- tempfile()
createLocalRepo(exampleRepoDir)
aoptions(key = "repoDir", value = exampleRepoDir)

data(iris)
saveToLocalRepo(iris)
getTagsLocal(digest::digest(iris, algo = "sha256"))

}

}
\references{
Biecek P and Kosinski M (2017). "archivist: An R Package for Managing,
Recording and Restoring Data Analysis Results." _Journal of Statistical
Software_, *82*(11), pp. 1-28. doi: 10.18637/jss.v082.i11 (URL:
http://doi.org/10.18637/jss.v082.i11).
URL https://github.com/pbiecek/archivist
}
\seealso{
Other archivist: 
\code{\link{Repository}},
\code{\link{Tags}},
\code{\link{\%a\%}()},
\code{\link{addHooksToPrint}()},
\code{\link{addTagsRepo}()},
\code{\link{aformat}()},
\code{\link{ahistory}()},
\code{\link{alink}()},
\code{\link{archivistPackage}},
\code{\link{aread}()},
\code{\link{areadLocal}()},
\code{\link{asearch}()},
\code{\link{asearchLocal}()},
\code{\link{asession}()},
\code{\link{atrace}()},
\code{\link{cache}()},
\code{\link{copyLocalRepo}()},
\code{\link{createLocalRepo}()},
\code{\link{createMDGallery}()},
\code{\link{deleteLocalRepo}()},
\code{\link{getRemoteHook}()},
\code{\link{getTagsLocal}()},
\code{\link{loadFromLocalRepo}()},
\code{\link{md5hash}},
\code{\link{removeTagsRepo}()},
\code{\link{restoreLibs}()},
\code{\link{rmFromLocalRepo}()},
\code{\link{saveToLocalRepo}()},
\code{\link{searchInLocalRepo}()},
\code{\link{setLocalRepo}()},
\code{\link{shinySearchInLocalRepo}()},
\code{\link{showLocalRepo}()},
\code{\link{splitTagsLocal}()},
\code{\link{summaryLocalRepo}()},
\code{\link{zipLocalRepo}()}
}
\author{
Przemyslaw Biecek, \email{przemyslaw.biecek@gmail.com}
}
\concept{archivist}
