% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addBracket.R
\name{addDiagnosticBracket}
\alias{addDiagnosticBracket}
\title{Annotate Diagnostic Features}
\usage{
addDiagnosticBracket(
  s,
  kind,
  feature = "featkind",
  top = "featdept",
  bottom = "featdepb",
  ...
)
}
\arguments{
\item{s}{\code{SoilProfileCollection} object}

\item{kind}{filter applied to \code{feature} column of diagnostic horizons registered within \code{s}}

\item{feature}{column name containing feature kind}

\item{top}{column name containing feature top depth}

\item{bottom}{column name containing feature top depth}

\item{...}{additional arguments passed to \code{addBracket}}
}
\description{
Annotate diagnostic features within a sketch of soil profiles.
}
\details{
Additional examples can be found in \href{http://ncss-tech.github.io/AQP/aqp/SPC-plotting-ideas.html}{this tutorial}.
}
\note{
This is a \code{low-level} plotting function: you must first plot a \code{SoilProfileCollection} object before using this function.
}
\seealso{
\code{\link[=addBracket]{addBracket()}}, \code{\link[=plotSPC]{plotSPC()}}
}
\author{
D.E. Beaudette
}
