% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.power.eq.R
\name{plot.power.eq}
\alias{plot.power.eq}
\title{Plot statistical power curves under a fixed budget across optimal design
parameters for equivalence testing}
\usage{
\method{plot}{power.eq}(
  expr = NULL,
  nlim = c(2, 300),
  plim = c(0.01, 0.99),
  Jlim = c(3, 300),
  powerlim = c(0, 1),
  plot.title = NULL,
  m = NULL,
  d = NULL,
  q = 1,
  power = 0.8,
  eq.dis = NULL,
  by = c("n", "p", "J"),
  legend = TRUE,
  nlab = "Level-One Sample Size (n)",
  plab = "Proportion (p)",
  Jlab = "Level-Two Sample Size (J)",
  powerlab = "Statistical Power"
)
}
\arguments{
\item{expr}{Returned objects from an od function (e.g., od.1.eq).}

\item{nlim}{The limits of the level-1 sample size (n) for calculating
and plotting power curves.}

\item{plim}{The limits of the proportion to the treated (p) for calculating
and plotting power curves.}

\item{Jlim}{The limits of the level-2 sample size (J) for calculating
and plotting power curves.}

\item{powerlim}{The power limits for plotting power curves.}

\item{plot.title}{The title of the plot (e.g., plot.title = "Power Curves").
The default is NULL.}

\item{m}{Total budget, default value is the total costs of sampling 600
individuals across treatment conditions.}

\item{d}{The estimated difference in two-group means.}

\item{q}{The number of predictors in the combined linear regression model.
Default is 1.}

\item{power}{Statistical power.}

\item{eq.dis}{A positive number to specify the distance from equivalence
bounds to \code{d}. The equivalence bounds are
c(-abs(d)-eq.dis, abs(d)+eq.dis).}

\item{by}{Dimensions to plot power curves by the optimal design parameters.
The default value is by all optimal design parameters for a type of design.
For example, default values are by = "p" for single-level designs,
by = c("n", "p") for two-level designs,
and by = c("n", "p", "J") for three-level designs.}

\item{legend}{Logical; present plot legend if TRUE. The default is TRUE.}

\item{nlab}{Label for the x-axis when the plot is by the optimal design
parameter "n".}

\item{plab}{Label for the x-axis when the plot is by the optimal design
parameter "p".}

\item{Jlab}{Label for the x-axis when the plot is by the optimal design
parameter "J".}

\item{powerlab}{The label for the statistical power.}
}
\description{
This function plots statistical power curves (for
    equivalence testing) under a fixed budget
    across optimal design parameters.
}
\examples{
# Optimal sample allocation identification
od <- od.1.eq(r12 = 0.5, c1 = 1, c1t = 10)
# plot the power curve
plot.power.eq(expr = od, d = 0.1, eq.dis = 0.1)

}
