% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alma-in.R
\name{alma_in}
\alias{alma_in}
\title{Check if dates are in an event set}
\usage{
alma_in(x, rschedule)
}
\arguments{
\item{x}{\verb{[Date]}

A vector of dates.}

\item{rschedule}{\verb{[rschedule]}

An rschedule, such as an rrule, runion, rintersect, or rsetdiff.}
}
\value{
A logical vector the same size as \code{x}.
}
\description{
\code{alma_in()} checks if \code{x} is in the event set of dates defined by the
rschedule.
}
\examples{
rrule <- weekly() \%>\%
  recur_on_day_of_week("Thursday")

# A Thursday and Friday
x <- as.Date("1970-01-01") + 0:1

alma_in(x, rrule)

# Every month, on the 2nd day of the month
rrule2 <- monthly() \%>\%
  recur_on_day_of_month(2)

# Make a larger set of multiple rules
rb <- runion(rrule, rrule2)

alma_in(x, rb)
}
