% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.GRiwrm.R
\name{mermaid}
\alias{mermaid}
\alias{mermaid_gen_link}
\alias{plot.mermaid}
\title{Plot a mermaid diagram}
\usage{
mermaid(
  diagram,
  format = "png",
  theme = "default",
  dir.dest = tempdir(),
  file.dest = paste0(rlang::hash(link), ".", format),
  link = mermaid_gen_link(diagram, theme = theme, format = format)
)

mermaid_gen_link(
  diagram,
  theme = "default",
  format = "png",
  server = "https://mermaid.ink"
)

\method{plot}{mermaid}(x, add = FALSE, ...)
}
\arguments{
\item{diagram}{Diagram in mermaid markdown-like language or file (as a connection or file name) containing a diagram specification}

\item{format}{Image format (either \code{"jpg"}, or \code{"png"}, or \code{"svg"})}

\item{theme}{Mermaid theme (See \href{https://mermaid.js.org/config/theming.html#available-themes}{available themes in Mermaid documentation})}

\item{dir.dest}{Destination folder for the downloaded image. This parameter is
ignored if \code{file.dest} contains a folder path.}

\item{file.dest}{Path to the downloaded image. It's combined with \code{dir.dest}
if it only contains the name of the file without a folder path.}

\item{link}{Link generated by \link{mermaid_gen_link}}

\item{server}{URL of the server used to generate the link}

\item{x}{\link{character} mermaid diagram dialect}

\item{add}{\link{logical} to add the diagram on the existing plot}

\item{...}{Other argument passed to \link{mermaid}}
}
\value{
\itemize{
\item \code{mermaid} returns the path to the downloaded image or \code{NA} if the download failed.
In this latter case, get the error message in the attribute "error".
\item \code{mermaid_gen_link} returns the link to the web service which generates the diagram
\item \code{plot.mermaid} produces a R plot with the mermaid diagram
}

Nothing, used for side effect.
}
\description{
These functions download the diagram from https://mermaid.ink which generates the image.
}
\details{
Compared to the \code{diagrammeR::mermaid} function, the generated image or plot
is not a HTMLwidget and can be knit in pdf through latex and
moreover, its size can be controlled with \code{fig.width} and \code{fig.height}.

If the generation failed (due to internet connection failure or syntax error
in mermaid script), the functions raises no error (see \code{mermaid} returned value).
}
\examples{
\dontrun{
diagram <- "flowchart LR\n  A --> B"
mermaid_gen_link(diagram)
f <- mermaid(diagram)
f

# For displaying the diagram in Rmarkdown document
knitr::include_graphics(mermaid(diagram))

# Clean temporary folder
unlink(f)
}

s <- "flowchart LR
A -> B"
class(s) <- c("mermaid", class(s))
plot(s)
}
