% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rel-totality.R
\name{rel_is_total}
\alias{rel_is_total}
\alias{rel_closure_total_fair}
\title{Total Binary Relations}
\usage{
rel_is_total(R)

rel_closure_total_fair(R)
}
\arguments{
\item{R}{an object coercible to a 0-1 (logical) square matrix,
representing a binary relation on a finite set.}
}
\value{
\code{rel_is_total} returns a single logical value.

\code{rel_closure_reflexive} returns a logical square matrix.
\code{\link{dimnames}} of \code{R} are preserved.
}
\description{
A binary relation \eqn{R} is \emph{total}
(or \emph{strong complete}), iff
for all \eqn{x}, \eqn{y} we have \eqn{xRy} or \eqn{yRx}.
}
\details{
Note that each total relation is also reflexive,
see \code{\link{rel_is_reflexive}}.

\code{rel_is_total} determines if a given binary relation
\code{R} is total.
The algorithm has \eqn{O(n^2)} time complexity,
where \eqn{n} is the number of rows in \code{R}.
If \code{R[i,j]} and \code{R[j,i]} is \code{NA}
for some \eqn{(i,j)}, then the functions outputs \code{NA}.

The problem of finding a total closure or reduction
is not well-defined in general.

When dealing with preorders, however, the following
closure may be useful, see (Gagolewski, 2013).
\emph{Fair totalization} of \eqn{R}, performed by
\code{rel_closure_total_fair}, is the minimal superset \eqn{R'} of \eqn{R}
such that if not \eqn{xRy} and not \eqn{yRx}
then \eqn{xR'y} and \eqn{yR'x}.

Even if \code{R} is transitive, the resulting relation
might not necessarily fulfil this property.
If you want a total preorder,
call \code{\link{rel_closure_transitive}} afterwards.
Missing values in \code{R} are not allowed and result in an error.
}
\references{
Gagolewski M., Scientific Impact Assessment Cannot be Fair,
   \emph{Journal of Informetrics} 7(4), 2013, pp. 792-802.\cr

Gagolewski M., Data Fusion: Theory, Methods, and Applications,
   Institute of Computer Science, Polish Academy of Sciences, 2015, 290 pp.
   isbn:978-83-63159-20-7
}
\seealso{
Other binary_relations: 
\code{\link{check_comonotonicity}()},
\code{\link{pord_nd}()},
\code{\link{pord_spread}()},
\code{\link{pord_weakdom}()},
\code{\link{rel_graph}()},
\code{\link{rel_is_antisymmetric}()},
\code{\link{rel_is_asymmetric}()},
\code{\link{rel_is_cyclic}()},
\code{\link{rel_is_irreflexive}()},
\code{\link{rel_is_reflexive}()},
\code{\link{rel_is_symmetric}()},
\code{\link{rel_is_transitive}()},
\code{\link{rel_reduction_hasse}()}
}
\concept{binary_relations}
