% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_cutoffs.R
\name{make_n_cutoffs}
\alias{make_n_cutoffs}
\title{Make a defined number of categories having similar number of positives in each category}
\usage{
make_n_cutoffs(v.fever, v.density, mintot, add1 = TRUE)
}
\arguments{
\item{v.fever}{numeric vector of 0/1 indicating fever or equivalent}

\item{v.density}{numeric vector of values >= 0 indicating the density}

\item{mintot}{minimum number of observations per category}

\item{add1}{a logical value to indicate the category started with 1 is included}
}
\value{
a vector with the cutoff points
}
\description{
Generate the categories in a way that each category have at least the
\code{mintot} number of observation. It generate all possible categories
were there is change and then collapse to have minimum number of observations
in each category
}
\examples{
{
make_n_cutoffs(malaria_df1$fever, malaria_df1$density, mintot=50)
}
}
