% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GroupSequentialDesign.R
\docType{class}
\name{GroupSequentialDesign-class}
\alias{GroupSequentialDesign-class}
\alias{GroupSequentialDesign}
\alias{GroupSequentialDesign,numeric-method}
\alias{TwoStageDesign,GroupSequentialDesign-method}
\alias{TwoStageDesign,GroupSequentialDesignSurvival-method}
\title{Group-sequential two-stage designs}
\usage{
GroupSequentialDesign(n1, ...)

\S4method{GroupSequentialDesign}{numeric}(
  n1,
  c1f,
  c1e,
  n2_pivots,
  c2_pivots,
  order = NULL,
  event_rate,
  ...
)

\S4method{TwoStageDesign}{GroupSequentialDesign}(n1, event_rate, ...)

\S4method{TwoStageDesign}{GroupSequentialDesignSurvival}(n1, ...)
}
\arguments{
\item{n1}{stage one sample size or \code{GroupSequentialDesign} object to convert
(overloaded from \code{\link{TwoStageDesign}})}

\item{...}{further optional arguments}

\item{c1f}{early futility stopping boundary}

\item{c1e}{early efficacy stopping boundary}

\item{n2_pivots}{numeric of length one, stage-two sample size}

\item{c2_pivots}{numeric vector, stage-two critical values on the integration
pivot points}

\item{order}{of the Gaussian quadrature rule to use for integration, set to
length(c2_pivots) if NULL, otherwise first value of c2_pivots is repeated
'order'-times.}

\item{event_rate}{probability that a subject in either group will eventually have an event,
only needs to be specified for time-to-event endpoints.}
}
\description{
Group-sequential designs are a sub-class of the \code{TwoStageDesign}
class with constant stage-two sample size.
See \code{\link{TwoStageDesign}} for slot details.
Any group-sequential design can be converted to a fully flexible
\code{TwoStageDesign} (see examples section).
}
\examples{
design <- GroupSequentialDesign(25, 0, 2, 25, c(1, 1.5, 2.5))
summary(design)

design_survival <- GroupSequentialDesign(25, 0, 2, 25, c(1, 1.5, 2.5), event_rate = 0.7)

TwoStageDesign(design)

TwoStageDesign(design_survival)

}
\seealso{
\code{\link{TwoStageDesign}} for superclass and inherited methods
}
