% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment_update.R
\name{seg_update}
\alias{seg_update}
\title{Update A Segment}
\usage{
seg_update(
  id = NULL,
  updates = NULL,
  locale = "en_US",
  debug = FALSE,
  company_id = Sys.getenv("AW_COMPANY_ID")
)
}
\arguments{
\item{id}{The id of the segment you are wanting to update}

\item{updates}{List of changes or entire definition object as a list object.}

\item{locale}{The URL query parameter locale. Supported values are en_US, fr_FR,
ja_JP, de_DE, es_ES, ko_KR, pt_BR, zh_CN, and zh_TW. This argument specifies
which language is to be used for localized sections of responses.}

\item{debug}{Set to \code{TRUE} to publish the full JSON request(s) being sent to the API to the console when the
function is called. The default is \code{FALSE}.}

\item{company_id}{Company ID. If an environment variable called \code{AW_COMPANY_ID} exists in \code{.Renviron} or
elsewhere and no \code{company_id} argument is provided, then the \code{AW_COMPANY_ID} value will be used.
Use \code{\link[=get_me]{get_me()}} to get a list of available \code{company_id} values.}
}
\value{
json string of updated segment information
}
\description{
Update a specific segment
}
