% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_crit.R
\name{derive_vars_crit}
\alias{derive_vars_crit}
\title{Derive Analysis Criterion Evaluation Variables}
\usage{
derive_vars_crit(dataset, prefix, crit_label, condition, criterion)
}
\arguments{
\item{dataset}{Input dataset}

\item{prefix}{Variables to add

The analysis criterion evaluation variable's name (i.e., \code{CRIT1})
This name is also used in order to create both character and numeric
flags variables (i.e., \code{CRIT1FL} and \code{CRIT1FN}).
If the name does not contain CRIT wording, it generates a flag variable
(ex: \code{ANL01FL}) whose logic is equals to \code{CRIT1} variable, without generating
additional numeric (ex: \code{ANL01FN}) and character (\code{ANL01}) variables.}

\item{crit_label}{Criterion value

A text description defining the condition necessary to satisfy the presence
of the criterion}

\item{condition}{Condition for selecting a subset

The condition specified in order to select a subset from the input dataset
in which the rule is applied.}

\item{criterion}{Criterion rule

The criterion that each selected row satisfies or not.
Returns \code{Y} or \code{N} for character variable and \code{1} or \code{0} for numeric variable
if the criterion is met or not, respectively.
Returns \code{NA} for not selected rows (not taken into account from condition)}
}
\value{
Dataset with criterion variables
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function is \emph{deprecated}, please use \code{admiral::derive_vars_crit_flag()} instead.

Derive analysis criterion evaluation result variable, paired with character
and numeric flags.
This function allows also the derivation of a CRIT like variable with a
different name (ex: \code{ANL01FL}), without generating additional numeric (ex: \code{ANL01FN})
and character label (ex: \code{ANL01}) variables.
}
\examples{
library(tibble)
library(admiral)
library(admiraldev)
library(dplyr)

input <- tribble(
  ~USUBJID, ~AVISITN, ~ISCAT, ~PARAMCD, ~AVAL, ~ISLLOQ,
  "999999-000001", 10, "IMMUNOLOGY", "J0033VN", 2, 4,
  "999999-000001", 10, "IMMUNOLOGY", "I0019NT", 3, 6,
  "999999-000001", 10, "IMMUNOLOGY", "M0019LN", 4, 4,
  "999999-000001", 10, "IMMUNOLOGY", "R0003MA", 3, 6,
  "999999-000001", 30, "IMMUNOLOGY", "J0033VN", 60, 4,
  "999999-000001", 30, "IMMUNOLOGY", "I0019NT", 567, 6,
  "999999-000001", 30, "IMMUNOLOGY", "M0019LN", 659, 4,
  "999999-000001", 30, "IMMUNOLOGY", "R0003MA", 250, 6,
  "999999-000002", 10, "IMMUNOLOGY", "J0033VN", 2, 4,
  "999999-000002", 10, "IMMUNOLOGY", "I0019NT", 7, 6,
  "999999-000002", 10, "IMMUNOLOGY", "M0019LN", 5, 4,
  "999999-000002", 10, "IMMUNOLOGY", "R0003MA", 3, 6,
  "999999-000002", 30, "IMMUNOLOGY", "J0033VN", 55, 4,
  "999999-000002", 30, "IMMUNOLOGY", "I0019NT", 89, 6,
  "999999-000002", 30, "IMMUNOLOGY", "M0019LN", 990, 4,
  "999999-000002", 30, "IMMUNOLOGY", "R0003MA", 340, 6,
  "999999-000003", 10, "IMMUNOLOGY", "J0033VN", 3, 4,
  "999999-000003", 10, "IMMUNOLOGY", "I0019NT", 6, 6,
  "999999-000003", 10, "IMMUNOLOGY", "M0019LN", 2, 4,
  "999999-000003", 10, "IMMUNOLOGY", "R0003MA", 2, 6,
  "999999-000003", 30, "IMMUNOLOGY", "J0033VN", 45, 4,
  "999999-000003", 30, "IMMUNOLOGY", "I0019NT", 381, 6,
  "999999-000003", 30, "IMMUNOLOGY", "M0019LN", 542, 4,
  "999999-000003", 30, "IMMUNOLOGY", "R0003MA", NA, 6
)


derive_vars_crit(
  dataset = input,
  prefix = "CRIT1",
  crit_label = "Titer >= ISLLOQ",
  condition = !is.na(AVAL) & !is.na(ISLLOQ),
  criterion = AVAL >= ISLLOQ
)

}
\seealso{
Other der_var: 
\code{\link{derive_var_aval_adis}()},
\code{\link{derive_vars_event_flag}()},
\code{\link{derive_vars_max_flag}()},
\code{\link{derive_vars_merged_vaccine}()},
\code{\link{derive_vars_params}()},
\code{\link{derive_vars_vaxdt}()}
}
\author{
Federico Baratin
}
\concept{der_var}
\keyword{der_var}
