% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ops.R
\name{adj_quotient}
\alias{adj_quotient}
\alias{adj_quotient_int}
\title{Quotient an adjacency list by a vector}
\usage{
adj_quotient(
  x,
  groups,
  duplicates = c("remove", "allow", "error", "warn"),
  self_loops = c("remove", "allow", "error", "warn")
)

adj_quotient_int(
  x,
  groups,
  n_groups,
  duplicates = c("remove", "allow", "error", "warn"),
  self_loops = c("remove", "allow", "error", "warn")
)
}
\arguments{
\item{x}{An \code{adj} list}

\item{groups}{A vector specifying the group membership for each node in \code{x}.
\code{adj_quotient()} will process this vector with \code{\link[vctrs:vec_group]{vctrs::vec_group_id()}};
\code{adj_quotient_int()} expects an (1-indexed) integer vector.}

\item{duplicates}{Controls handling of duplicate neighbors. The value
\code{"warn"} warns the user; \code{"error"} throws an error; \code{"allow"} allows
duplicates, and \code{"remove"} removes duplicates silently and then sets the
corresponding attribute to \code{"error"}.}

\item{self_loops}{Controls handling of self-loops (nodes that are adjacent
to themselves). The value \code{"warn"} warns the user; \code{"error"} throws an
error; \code{"allow"} allows self-loops, and \code{"remove"} removes self-loops
silently and then sets the corresponding attribute to \code{"error"}.}

\item{n_groups}{Number of unique groups.}
}
\value{
A new \code{adj} list.
}
\description{
Computes the quotient graph of a given adjacency list by a provided grouping
vector. Nodes in the same groups are merged into single nodes in the quotient
graph. The resulting multi-edges and self-loops are handled according to the
specified parameters.
}
\examples{
a <- adj(konigsberg$bridge_to, ids = konigsberg$area, duplicates = "allow")
# merge two islands (A and D)
adj_quotient(a, c("AD", "B", "C", "AD"))
adj_quotient_int(a, c(1L, 2L, 3L, 1L), n_groups = 3L, self_loops = "allow")
}
