% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accucor_lib.R
\name{deuterium_isotope_correction}
\alias{deuterium_isotope_correction}
\title{Natural Abundance deuterium isotope correction for one metabolite}
\usage{
deuterium_isotope_correction(
  formula,
  datamatrix,
  label,
  Resolution,
  ResDefAt = 200,
  purity = 0.99,
  ReportPoolSize = TRUE
)
}
\arguments{
\item{formula}{String representing molecular formula}

\item{datamatrix}{Matrix of abundances for each sample for each isotope}

\item{label}{vector of integer labels}

\item{Resolution}{For Exactive, the Resolution is 100000, defined at Mw 200}

\item{ResDefAt}{Resolution defined at (in Mw), e.g. 200 Mw}

\item{purity}{Deuterium purity, default: 0.99}

\item{ReportPoolSize}{default: TRUE}
}
\value{
Named list of matrices: 'Corrected', 'Normalized',
     'PoolBeforeDF', and 'PoolAfterDF'.
}
\description{
Natural Abundance deuterium isotope correction for one metabolite
}
\examples{
\dontrun{
deuterium_isotope_correction(
  formula = "C6H13O9P",
  datamatrix = DataMatrix,
  label = c(0, 1),
  Resolution = 100000
)
}
}
