% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accrual_predict.R
\name{accrual_predict}
\alias{accrual_predict}
\title{accrual_predict}
\usage{
accrual_predict(accrual_df, accrual_fit, target)
}
\arguments{
\item{accrual_df}{accrual data frame produced by \code{accrual_create_df} (optionally with by option as a list)}

\item{accrual_fit}{linear model produced by accrual_linear_model, can be a list with the same length as accrual_df}

\item{target}{target sample size or date to predict end date or expected sample size, respectively.
A single number or date, or a named vector with the same length as accrual_df (to add site-specific targets).}
}
\value{
Returns the predicted end date(s) or the predicted sample size(s).
}
\description{
accrual_predict
}
\details{
Prediction of end date based on an accrual data frame produced by \code{accrual_create_df},
a fitted regression model produced by accrual_linear_model and a target sample size.
}
\examples{
\donttest{
data(accrualdemo)
accrual_df<-accrual_create_df(accrualdemo$date)
accrual_model<-accrual_linear_model(accrual_df)
#predict date for a specific n
accrual_predict(accrual_df,accrual_model,target=300)
#predict n at a specific date
accrual_predict(accrual_df,accrual_model,target=as.Date("2020-11-01"))

#different start and current date
accrual_df<-accrual_create_df(accrualdemo$date,start_date=as.Date("2020-07-09"),
    current_date=as.Date("2020-10-15"))
accrual_model<-accrual_linear_model(accrual_df)
accrual_predict(accrual_df,accrual_model,target=300)

 #accrual_df with by option
 accrual_df<-accrual_create_df(accrualdemo$date,by=accrualdemo$site)
accrual_model<-accrual_linear_model(accrual_df)
accrual_predict(accrual_df,accrual_model,
  target=c("Site 1"=160,"Site 2"=100,"Site 3"=40,"Overall"=300))
accrual_predict(accrual_df,accrual_model,target=as.Date("2020-11-01"))
}
}
