% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc.R
\name{cc}
\alias{cc}
\title{cc}
\usage{
cc(X, Y, Zx = NULL, Zy = Zx, numb_cc = NULL, fill.na = FALSE)
}
\arguments{
\item{X}{See \code{x} in \code{\link[stats]{cancor}} for a proper documentation.}

\item{Y}{See \code{y} in \code{\link[stats]{cancor}} for a proper documentation.}

\item{Zx}{(\code{=NULL} by default) covariates (i.e. nuisance) of \code{X}. If different from \code{NULL}, the \code{X} are residualized by \code{Zx} before entering \code{cc()}. IMPORTANT: if Zx is not NULL, include the intercept (if appropriate!)}

\item{Zy}{(\code{=Zx} by default) covariates of \code{Y}. Same use of \code{Zx}.}

\item{numb_cc}{number of (pairs of) canonical correlations to be extracted}

\item{fill.na}{replace \code{NA} in \code{X} and \code{Y} with column mean before enter \code{cc()}.}
}
\value{
It returns an \code{acca} object. This object contains the same list as returned by \code{\link[CCA]{cc}}, while it also contains \code{prop_expl_var} which is a \code{list} reporting the proportion of explained (total) variance of \code{X} and \code{Y} by each component (i.e. mode).


L=matrix(rnorm(10),10,1)
X=matrix(rnorm(50),10,5)
Y=matrix(rnorm(70),10,7)
Z=matrix(rnorm(20),10,2)

X[,1]=X[,1]+2*L
Y[,1]=Y[,1]+2*L
mod=cc(X,Y,Z)
mod

ccbiplot(mod)
}
\description{
Very similar \code{cancor()} of package \code{stats}, but 1) it allows for X and Y to be rank deficient, 2) it allows for categorical variables and 3) it allows for covariates, 4) more (see below).
}
