% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha.R
\name{menhinick}
\alias{menhinick}
\title{Menhinick's richness index}
\usage{
menhinick(x)
}
\arguments{
\item{x}{A numeric vector of species counts.}
}
\value{
Menhinick's richness index, \eqn{R > 0}. The index is undefined when
  the total number of counts is 0, in which case we return \code{NaN}.
}
\description{
Menhinick's richness index
}
\details{
For a vector \code{x} of raw species counts, the Menhinick's richness index
is \eqn{\frac{S}{\sqrt{N}}}, where \eqn{N} is the total number
of counts and \eqn{S} is the total number of species observed.

This index is appropriate only for raw counts, not transformed counts or
proportions.

Equivalent to \code{menhinick()} in \code{skbio.diversity.alpha}.
}
\examples{
x <- c(15, 6, 4, 0, 3, 0)
menhinick(x)
}
