% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unifrac.R
\docType{data}
\name{lozupone_tree}
\alias{lozupone_tree}
\alias{lozupone_panel_a}
\alias{lozupone_panel_b}
\title{Example data for UniFrac distance}
\format{\code{lozupone_tree} is a phylogenetic tree with 14 tips, labeled
A-N. It was created with the \code{ape} library.

The data frames \code{lozupone_panel_a} and \code{lozupone_panel_b} are
transcribed from Figure 1 of the paper. They have the following columns:
\describe{
  \item{Species}{The species label, matching to the phylogenetic tree.}
  \item{SampleID}{The community, either "Circle" or "Square".}
  \item{Counts}{
    The number of organisms counted per species, always 1 for this
    example.}
}}
\source{
Lozupone C, Knight R. UniFrac: a new phylogenetic method for
comparing microbial communities. Applied and environmental microbiology.
2005;71(12):8228–8235. 10.1128/AEM.71.12.8228-8235.2005
}
\usage{
lozupone_tree

lozupone_panel_a

lozupone_panel_b
}
\description{
This example was used to illustrate unweighted UniFrac distance in Lozupone
and Knight (2005).
}
\keyword{datasets}
