% Generated by roxygen2 (4.0.2): do not edit by hand
\name{MA}
\alias{MA}
\title{Moving Average Filter}
\usage{
MA(x, nlag = NULL, plot = TRUE)
}
\arguments{
\item{x}{a numeric vector or univariate time series.}

\item{nlag}{the number of period to calculate the average. The default is \code{NULL}.}

\item{plot}{a logical value indicating to print out the plot. The default is \code{TRUE}.}
}
\value{
A list with class "\code{MA}" containing the following components:
\item{estimate}{the smoothed values.}
\item{nlag}{the period used to compute the average.}
\item{accurate}{the accurate measurements.}
}
\description{
Applies moving average filter to estimate the linear trend or
nonseasonal pattern.
}
\details{
The moving average filter uses the unweight mean of (2*\code{nlag} + 1) adjacent
observations. That is,
\deqn{hat{X}[t] = (X[t - nlag] + ... + X[t] + ...+ X[t + nlag])/(2*nlag + 1)}
for \eqn{nlag < t < n - nlag}.
For the values at the boundary \eqn{t \le nlag} or \eqn{n - nlag \le t \le n}, you can
refer to Equation (7) in Qiu \emph{et al.,} (2013) for details of calculations.
The default method for choosing the optimal \code{nlag} uses the rule-of-thumb
criterion proposed by Qiu, \emph{et al}., (2013), in which they showed that the moving
average
is a special case of local linear estimator in the sense that the kernel function is the
uniform one, and the moving average period \code{nlag} is a function of bandwidth. Thus,
choosing the optimal \code{nlag} is equivalent to choosing the optimal bandwidth in local
linear regression.

The plot of original values v.s fitted values will be displayed if \code{plot = TRUE}.
}
\examples{
x <- arima.sim(list(order = c(1,0,0),ar = 0.4),n = 100)
y <- 5*(1:100)/100 + x
MA(y)

# moving average filter for co2 data
MA(co2)
}
\author{
Debin Qiu
}
\references{
D. Qiu, Q. Shao, and L. Yang (2013), Efficient inference for autoregressive
coefficient in the presence of trend. \emph{Journal of Multivariate Analysis}
114, 40-53.

P.J. Brockwell, R.A. Davis, Time Series: Theory and Methods, second ed.,
Springer, New York, 1991.
}

